(*
% File     : KRS107+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : DL Test: fact4.1
% Version  : Especial.
% English  : 
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : inconsistent_description-logic-Manifest604 [Bec03]
% Status   : Unsatisfiable
% Rating   : 0.00 v3.1.0
% Status (intuit.) : Open (Problem negated)
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :   53 (   1 unit)
%            Number of atoms       :  148 (  37 equality)
%            Maximal formula depth :    7 (   5 average)
%            Number of connectives :   98 (   3 ~  ;   0  |;  44  &)
%                                         (   6 <=>;  45 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   22 (   0 propositional; 1-2 arity)
%            Number of functors    :    1 (   1 constant; 0-0 arity)
%            Number of variables   :  129 (   0 singleton; 124 !;   5 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable xsd_string_ : Universe -> Prop.
Variable xsd_integer_ : Universe -> Prop.
Variable rrxa_ : Universe -> Universe -> Prop.
Variable rrx4a_ : Universe -> Universe -> Prop.
Variable rrx4_ : Universe -> Universe -> Prop.
Variable rrx3a_ : Universe -> Universe -> Prop.
Variable rrx3_ : Universe -> Universe -> Prop.
Variable rrx2a_ : Universe -> Universe -> Prop.
Variable rrx2_ : Universe -> Universe -> Prop.
Variable rrx1a_ : Universe -> Universe -> Prop.
Variable rrx1_ : Universe -> Universe -> Prop.
Variable rrx_ : Universe -> Universe -> Prop.
Variable ra_Px1_ : Universe -> Universe -> Prop.
Variable cowlThing_ : Universe -> Prop.
Variable cowlNothing_ : Universe -> Prop.
Variable cc2_ : Universe -> Prop.
Variable cc1_ : Universe -> Prop.
Variable ca_Cx1xcomp_ : Universe -> Prop.
Variable ca_Cx1_ : Universe -> Prop.
Variable ca_Ax2_ : Universe -> Prop.
Variable cUnsatisfiable_ : Universe -> Prop.

Variable i2003_11_14_17_21_01226_ : Universe.

Variable cUnsatisfiable_substitution_1_1 : (forall A B : Universe, ((A = B /\ cUnsatisfiable_ A) -> cUnsatisfiable_ B)).
Variable ca_Ax2_substitution_1_2 : (forall A B : Universe, ((A = B /\ ca_Ax2_ A) -> ca_Ax2_ B)).
Variable ca_Cx1_substitution_1_3 : (forall A B : Universe, ((A = B /\ ca_Cx1_ A) -> ca_Cx1_ B)).
Variable ca_Cx1xcomp_substitution_1_4 : (forall A B : Universe, ((A = B /\ ca_Cx1xcomp_ A) -> ca_Cx1xcomp_ B)).
Variable cc1_substitution_1_5 : (forall A B : Universe, ((A = B /\ cc1_ A) -> cc1_ B)).
Variable cc2_substitution_1_6 : (forall A B : Universe, ((A = B /\ cc2_ A) -> cc2_ B)).
Variable cowlNothing_substitution_1_7 : (forall A B : Universe, ((A = B /\ cowlNothing_ A) -> cowlNothing_ B)).
Variable cowlThing_substitution_1_8 : (forall A B : Universe, ((A = B /\ cowlThing_ A) -> cowlThing_ B)).
Variable ra_Px1_substitution_1_9 : (forall A B C : Universe, ((A = B /\ ra_Px1_ A C) -> ra_Px1_ B C)).
Variable ra_Px1_substitution_2_10 : (forall A B C : Universe, ((A = B /\ ra_Px1_ C A) -> ra_Px1_ C B)).
Variable rrx_substitution_1_11 : (forall A B C : Universe, ((A = B /\ rrx_ A C) -> rrx_ B C)).
Variable rrx_substitution_2_12 : (forall A B C : Universe, ((A = B /\ rrx_ C A) -> rrx_ C B)).
Variable rrx1_substitution_1_13 : (forall A B C : Universe, ((A = B /\ rrx1_ A C) -> rrx1_ B C)).
Variable rrx1_substitution_2_14 : (forall A B C : Universe, ((A = B /\ rrx1_ C A) -> rrx1_ C B)).
Variable rrx1a_substitution_1_15 : (forall A B C : Universe, ((A = B /\ rrx1a_ A C) -> rrx1a_ B C)).
Variable rrx1a_substitution_2_16 : (forall A B C : Universe, ((A = B /\ rrx1a_ C A) -> rrx1a_ C B)).
Variable rrx2_substitution_1_17 : (forall A B C : Universe, ((A = B /\ rrx2_ A C) -> rrx2_ B C)).
Variable rrx2_substitution_2_18 : (forall A B C : Universe, ((A = B /\ rrx2_ C A) -> rrx2_ C B)).
Variable rrx2a_substitution_1_19 : (forall A B C : Universe, ((A = B /\ rrx2a_ A C) -> rrx2a_ B C)).
Variable rrx2a_substitution_2_20 : (forall A B C : Universe, ((A = B /\ rrx2a_ C A) -> rrx2a_ C B)).
Variable rrx3_substitution_1_21 : (forall A B C : Universe, ((A = B /\ rrx3_ A C) -> rrx3_ B C)).
Variable rrx3_substitution_2_22 : (forall A B C : Universe, ((A = B /\ rrx3_ C A) -> rrx3_ C B)).
Variable rrx3a_substitution_1_23 : (forall A B C : Universe, ((A = B /\ rrx3a_ A C) -> rrx3a_ B C)).
Variable rrx3a_substitution_2_24 : (forall A B C : Universe, ((A = B /\ rrx3a_ C A) -> rrx3a_ C B)).
Variable rrx4_substitution_1_25 : (forall A B C : Universe, ((A = B /\ rrx4_ A C) -> rrx4_ B C)).
Variable rrx4_substitution_2_26 : (forall A B C : Universe, ((A = B /\ rrx4_ C A) -> rrx4_ C B)).
Variable rrx4a_substitution_1_27 : (forall A B C : Universe, ((A = B /\ rrx4a_ A C) -> rrx4a_ B C)).
Variable rrx4a_substitution_2_28 : (forall A B C : Universe, ((A = B /\ rrx4a_ C A) -> rrx4a_ C B)).
Variable rrxa_substitution_1_29 : (forall A B C : Universe, ((A = B /\ rrxa_ A C) -> rrxa_ B C)).
Variable rrxa_substitution_2_30 : (forall A B C : Universe, ((A = B /\ rrxa_ C A) -> rrxa_ C B)).
Variable xsd_integer_substitution_1_31 : (forall A B : Universe, ((A = B /\ xsd_integer_ A) -> xsd_integer_ B)).
Variable xsd_string_substitution_1_32 : (forall A B : Universe, ((A = B /\ xsd_string_ A) -> xsd_string_ B)).
Variable axiom_0_33 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_34 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_35 : (forall X : Universe, (cUnsatisfiable_ X <-> ((exists Y : Universe, (rrx3_ X Y /\ cc1_ Y)) /\ ((exists Y : Universe, (rrx4_ X Y /\ cc2_ Y)) /\ ca_Cx1_ X)))).
Variable axiom_3_36 : (forall X : Universe, (ca_Ax2_ X <-> (cc2_ X /\ cc1_ X))).
Variable axiom_4_37 : (forall X : Universe, (ca_Cx1_ X <-> (exists Y0 : Universe, ra_Px1_ X Y0))).
Variable axiom_5_38 : (forall X : Universe, (ca_Cx1xcomp_ X <-> (exists Y : Universe, (rrx3_ X Y /\ ca_Ax2_ Y)))).
Variable axiom_6_39 : (forall X : Universe, (ca_Cx1xcomp_ X <-> ~((exists Y : Universe, ra_Px1_ X Y)))).
Variable axiom_7_40 : (forall X Y Z : Universe, ((rrx_ X Y /\ rrx_ X Z) -> Y = Z)).
Variable axiom_8_41 : (forall X Y Z : Universe, ((rrx3_ X Y /\ rrx3_ X Z) -> Y = Z)).
Variable axiom_9_42 : (forall X Y Z : Universe, ((rrx3a_ X Y /\ rrx3a_ X Z) -> Y = Z)).
Variable axiom_10_43 : (forall X Y Z : Universe, ((rrx4_ X Y /\ rrx4_ X Z) -> Y = Z)).
Variable axiom_11_44 : (forall X Y Z : Universe, ((rrx4a_ X Y /\ rrx4a_ X Z) -> Y = Z)).
Variable axiom_12_45 : cUnsatisfiable_ i2003_11_14_17_21_01226_.
Variable axiom_13_46 : (forall X Y : Universe, (rrx3_ X Y -> rrx1_ X Y)).
Variable axiom_14_47 : (forall X Y : Universe, (rrx3a_ X Y -> rrxa_ X Y)).
Variable axiom_15_48 : (forall X Y : Universe, (rrx4a_ X Y -> rrxa_ X Y)).
Variable axiom_16_49 : (forall X Y : Universe, (rrx4_ X Y -> rrx2_ X Y)).
Variable axiom_17_50 : (forall X Y : Universe, (rrx4_ X Y -> rrx_ X Y)).
Variable axiom_18_51 : (forall X Y : Universe, (rrx3a_ X Y -> rrx1a_ X Y)).
Variable axiom_19_52 : (forall X Y : Universe, (rrx4a_ X Y -> rrx2a_ X Y)).
Variable axiom_20_53 : (forall X Y : Universe, (rrx3_ X Y -> rrx_ X Y)).

Theorem conjecture_54 : False.
Proof.
  time hprover.
Qed.

End FOFProblem.
