(*
% File     : KRS104+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : DL Test: fact1.1
% Version  : Especial.
% English  : If a, b and c are disjoint, then:
%                (a and b) or (b and c) or (c and a)
%            is unsatisfiable.
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : inconsistent_description-logic-Manifest601 [Bec03]
% Status   : Unsatisfiable
% Rating   : 0.00 v3.1.0
% Status (intuit.) : Open (Problem negated)
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :   24 (   1 unit)
%            Number of atoms       :   53 (   0 equality)
%            Maximal formula depth :    5 (   4 average)
%            Number of connectives :   38 (   9 ~  ;   0  |;   7  &)
%                                         (  20 <=>;   2 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   26 (   0 propositional; 1-2 arity)
%            Number of functors    :    1 (   1 constant; 0-0 arity)
%            Number of variables   :   37 (   0 singleton;  23 !;  14 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable xsd_string_ : Universe -> Prop.
Variable xsd_integer_ : Universe -> Prop.
Variable ra_Px8_ : Universe -> Universe -> Prop.
Variable ra_Px7_ : Universe -> Universe -> Prop.
Variable ra_Px6_ : Universe -> Universe -> Prop.
Variable ra_Px5_ : Universe -> Universe -> Prop.
Variable ra_Px3_ : Universe -> Universe -> Prop.
Variable ra_Px2_ : Universe -> Universe -> Prop.
Variable ra_Px1_ : Universe -> Universe -> Prop.
Variable cowlThing_ : Universe -> Prop.
Variable cowlNothing_ : Universe -> Prop.
Variable ccxcomp_ : Universe -> Prop.
Variable cc_ : Universe -> Prop.
Variable cbxcomp_ : Universe -> Prop.
Variable cb_ : Universe -> Prop.
Variable ca_Cx8xcomp_ : Universe -> Prop.
Variable ca_Cx8_ : Universe -> Prop.
Variable ca_Cx7xcomp_ : Universe -> Prop.
Variable ca_Cx7_ : Universe -> Prop.
Variable ca_Cx6xcomp_ : Universe -> Prop.
Variable ca_Cx6_ : Universe -> Prop.
Variable ca_Cx1xcomp_ : Universe -> Prop.
Variable ca_Cx1_ : Universe -> Prop.
Variable ca_ : Universe -> Prop.
Variable cUnsatisfiablexcomp_ : Universe -> Prop.
Variable cUnsatisfiable_ : Universe -> Prop.

Variable i2003_11_14_17_20_50869_ : Universe.

Variable axiom_0_1 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_2 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_3 : (forall X : Universe, (cUnsatisfiable_ X <-> ~((exists Y : Universe, ra_Px5_ X Y)))).
Variable axiom_3_4 : (forall X : Universe, (cUnsatisfiablexcomp_ X <-> (ca_Cx7_ X /\ (ca_Cx8_ X /\ ca_Cx6_ X)))).
Variable axiom_4_5 : (forall X : Universe, (cUnsatisfiablexcomp_ X <-> (exists Y0 : Universe, ra_Px5_ X Y0))).
Variable axiom_5_6 : (forall X : Universe, (ca_ X -> ca_Cx1_ X)).
Variable axiom_6_7 : (forall X : Universe, (cb_ X <-> (exists Y0 : Universe, ra_Px3_ X Y0))).
Variable axiom_7_8 : (forall X : Universe, (cb_ X -> ccxcomp_ X)).
Variable axiom_8_9 : (forall X : Universe, (cbxcomp_ X <-> ~((exists Y : Universe, ra_Px3_ X Y)))).
Variable axiom_9_10 : (forall X : Universe, (cc_ X <-> (exists Y0 : Universe, ra_Px2_ X Y0))).
Variable axiom_10_11 : (forall X : Universe, (ccxcomp_ X <-> ~((exists Y : Universe, ra_Px2_ X Y)))).
Variable axiom_11_12 : (forall X : Universe, (ca_Cx1_ X <-> (cbxcomp_ X /\ ccxcomp_ X))).
Variable axiom_12_13 : (forall X : Universe, (ca_Cx1_ X <-> (exists Y0 : Universe, ra_Px1_ X Y0))).
Variable axiom_13_14 : (forall X : Universe, (ca_Cx1xcomp_ X <-> ~((exists Y : Universe, ra_Px1_ X Y)))).
Variable axiom_14_15 : (forall X : Universe, (ca_Cx6_ X <-> ~((exists Y : Universe, ra_Px6_ X Y)))).
Variable axiom_15_16 : (forall X : Universe, (ca_Cx6xcomp_ X <-> (ca_ X /\ cb_ X))).
Variable axiom_16_17 : (forall X : Universe, (ca_Cx6xcomp_ X <-> (exists Y0 : Universe, ra_Px6_ X Y0))).
Variable axiom_17_18 : (forall X : Universe, (ca_Cx7_ X <-> (exists Y0 : Universe, ra_Px7_ X Y0))).
Variable axiom_18_19 : (forall X : Universe, (ca_Cx7xcomp_ X <-> (cc_ X /\ ca_ X))).
Variable axiom_19_20 : (forall X : Universe, (ca_Cx7xcomp_ X <-> ~((exists Y : Universe, ra_Px7_ X Y)))).
Variable axiom_20_21 : (forall X : Universe, (ca_Cx8_ X <-> ~((exists Y : Universe, ra_Px8_ X Y)))).
Variable axiom_21_22 : (forall X : Universe, (ca_Cx8xcomp_ X <-> (exists Y0 : Universe, ra_Px8_ X Y0))).
Variable axiom_22_23 : (forall X : Universe, (ca_Cx8xcomp_ X <-> (cc_ X /\ cb_ X))).
Variable axiom_23_24 : cUnsatisfiable_ i2003_11_14_17_20_50869_.

Theorem conjecture_25 : False.
Proof.
  time hprover.
Qed.

End FOFProblem.
