(*
% File     : KRS102+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : This is the classic 3 SAT problem
% Version  : Especial.
% English  :
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : inconsistent_description-logic-Manifest502 [Bec03]
% Status   : Unsatisfiable
% Rating   : 0.33 v3.1.0
% Status (intuit.) : Open (Problem negated)
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :   83 (  21 unit)
%            Number of atoms       :  205 ( 161 equality)
%            Maximal formula depth :    5 (   3 average)
%            Number of connectives :  125 (   3 ~  ; 100  |;   6  &)
%                                         (  11 <=>;   5 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    6 (   0 propositional; 1-2 arity)
%            Number of functors    :   20 (  20 constant; 0-0 arity)
%            Number of variables   :   22 (   0 singleton;  22 !;   0 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable xsd_string_ : Universe -> Prop.
Variable xsd_integer_ : Universe -> Prop.
Variable cowlThing_ : Universe -> Prop.
Variable cowlNothing_ : Universe -> Prop.
Variable cTorF_ : Universe -> Prop.

Variable iplus9_ : Universe.
Variable iplus8_ : Universe.
Variable iplus7_ : Universe.
Variable iplus6_ : Universe.
Variable iplus5_ : Universe.
Variable iplus4_ : Universe.
Variable iplus3_ : Universe.
Variable iplus2_ : Universe.
Variable iplus1_ : Universe.
Variable iminus9_ : Universe.
Variable iminus8_ : Universe.
Variable iminus7_ : Universe.
Variable iminus6_ : Universe.
Variable iminus5_ : Universe.
Variable iminus4_ : Universe.
Variable iminus3_ : Universe.
Variable iminus2_ : Universe.
Variable iminus1_ : Universe.
Variable iT_ : Universe.
Variable iF_ : Universe.

Variable cTorF_substitution_1_1 : (forall A B : Universe, ((A = B /\ cTorF_ A) -> cTorF_ B)).
Variable cowlNothing_substitution_1_2 : (forall A B : Universe, ((A = B /\ cowlNothing_ A) -> cowlNothing_ B)).
Variable cowlThing_substitution_1_3 : (forall A B : Universe, ((A = B /\ cowlThing_ A) -> cowlThing_ B)).
Variable xsd_integer_substitution_1_4 : (forall A B : Universe, ((A = B /\ xsd_integer_ A) -> xsd_integer_ B)).
Variable xsd_string_substitution_1_5 : (forall A B : Universe, ((A = B /\ xsd_string_ A) -> xsd_string_ B)).
Variable axiom_0_6 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_7 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_8 : (forall X : Universe, (cTorF_ X <-> (X = iplus1_ \/ X = iminus1_))).
Variable axiom_3_9 : (forall X : Universe, (cTorF_ X <-> (X = iminus4_ \/ X = iplus4_))).
Variable axiom_4_10 : (forall X : Universe, (cTorF_ X <-> (X = iplus2_ \/ X = iminus2_))).
Variable axiom_5_11 : (forall X : Universe, (cTorF_ X <-> (X = iplus7_ \/ X = iminus7_))).
Variable axiom_6_12 : (forall X : Universe, (cTorF_ X <-> (X = iplus5_ \/ X = iminus5_))).
Variable axiom_7_13 : (forall X : Universe, (cTorF_ X <-> (X = iplus3_ \/ X = iminus3_))).
Variable axiom_8_14 : (forall X : Universe, (cTorF_ X <-> (X = iT_ \/ X = iF_))).
Variable axiom_9_15 : (forall X : Universe, (cTorF_ X <-> (X = iplus8_ \/ X = iminus8_))).
Variable axiom_10_16 : (forall X : Universe, (cTorF_ X <-> (X = iminus6_ \/ X = iplus6_))).
Variable axiom_11_17 : (forall X : Universe, (cTorF_ X <-> (X = iminus9_ \/ X = iplus9_))).
Variable axiom_12_18 : cowlThing_ iF_.
Variable axiom_13_19 : (iT_ = iminus6_ \/ (iT_ = iplus2_ \/ iT_ = iplus1_)).
Variable axiom_14_20 : (iT_ = iminus6_ \/ (iT_ = iplus9_ \/ iT_ = iminus7_)).
Variable axiom_15_21 : (iT_ = iplus8_ \/ (iT_ = iminus3_ \/ iT_ = iplus7_)).
Variable axiom_16_22 : (iT_ = iplus5_ \/ (iT_ = iplus9_ \/ iT_ = iminus7_)).
Variable axiom_17_23 : (iT_ = iminus6_ \/ (iT_ = iplus1_ \/ iT_ = iplus9_)).
Variable axiom_18_24 : (iT_ = iplus3_ \/ (iT_ = iminus9_ \/ iT_ = iplus4_)).
Variable axiom_19_25 : (iT_ = iminus9_ \/ (iT_ = iminus6_ \/ iT_ = iplus1_)).
Variable axiom_20_26 : cowlThing_ iT_.
Variable axiom_21_27 : (iT_ = iminus8_ \/ (iT_ = iminus4_ \/ iT_ = iplus9_)).
Variable axiom_22_28 : (iT_ = iplus3_ \/ (iT_ = iplus6_ \/ iT_ = iplus4_)).
Variable axiom_23_29 : (iT_ = iplus1_ \/ (iT_ = iplus7_ \/ iT_ = iplus4_)).
Variable axiom_24_30 : (iT_ = iplus3_ \/ (iT_ = iminus8_ \/ iT_ = iminus2_)).
Variable axiom_25_31 : (iT_ = iminus8_ \/ (iT_ = iplus6_ \/ iT_ = iplus4_)).
Variable axiom_26_32 : (iT_ = iplus3_ \/ (iT_ = iminus9_ \/ iT_ = iminus2_)).
Variable axiom_27_33 : (iT_ = iplus6_ \/ (iT_ = iminus2_ \/ iT_ = iminus7_)).
Variable axiom_28_34 : (iT_ = iplus6_ \/ (iT_ = iminus4_ \/ iT_ = iminus3_)).
Variable axiom_29_35 : (iT_ = iminus6_ \/ (iT_ = iplus1_ \/ iT_ = iminus4_)).
Variable axiom_30_36 : (iT_ = iplus1_ \/ (iT_ = iminus4_ \/ iT_ = iplus9_)).
Variable axiom_31_37 : (iT_ = iplus8_ \/ (iT_ = iplus2_ \/ iT_ = iminus4_)).
Variable axiom_32_38 : (iT_ = iplus5_ \/ (iT_ = iminus4_ \/ iT_ = iplus9_)).
Variable axiom_33_39 : (iT_ = iminus5_ \/ (iT_ = iplus6_ \/ iT_ = iplus4_)).
Variable axiom_34_40 : (iT_ = iplus8_ \/ (iT_ = iminus5_ \/ iT_ = iplus7_)).
Variable axiom_35_41 : (iT_ = iminus5_ \/ (iT_ = iminus9_ \/ iT_ = iminus2_)).
Variable axiom_36_42 : (iT_ = iminus4_ \/ (iT_ = iminus3_ \/ iT_ = iminus7_)).
Variable axiom_37_43 : (iT_ = iplus2_ \/ (iT_ = iplus4_ \/ iT_ = iminus1_)).
Variable axiom_38_44 : (iT_ = iminus2_ \/ (iT_ = iplus1_ \/ iT_ = iminus3_)).
Variable axiom_39_45 : (iT_ = iplus3_ \/ (iT_ = iplus6_ \/ iT_ = iminus4_)).
Variable axiom_40_46 : (iT_ = iminus8_ \/ (iT_ = iminus9_ \/ iT_ = iminus4_)).
Variable axiom_41_47 : (iT_ = iplus3_ \/ (iT_ = iplus1_ \/ iT_ = iplus4_)).
Variable axiom_42_48 : (iT_ = iplus8_ \/ (iT_ = iplus2_ \/ iT_ = iminus3_)).
Variable axiom_43_49 : (iT_ = iplus3_ \/ (iT_ = iminus8_ \/ iT_ = iplus9_)).
Variable axiom_44_50 : (iT_ = iplus8_ \/ (iT_ = iplus3_ \/ iT_ = iminus7_)).
Variable axiom_45_51 : (iT_ = iminus5_ \/ (iT_ = iminus8_ \/ iT_ = iminus3_)).
Variable axiom_46_52 : (iT_ = iplus3_ \/ (iT_ = iplus9_ \/ iT_ = iplus4_)).
Variable axiom_47_53 : (iT_ = iminus8_ \/ (iT_ = iplus6_ \/ iT_ = iminus7_)).
Variable axiom_48_54 : (iT_ = iminus9_ \/ (iT_ = iminus2_ \/ iT_ = iplus7_)).
Variable axiom_49_55 : (iT_ = iplus5_ \/ (iT_ = iminus8_ \/ iT_ = iminus3_)).
Variable axiom_50_56 : (iT_ = iminus5_ \/ (iT_ = iplus2_ \/ iT_ = iminus7_)).
Variable axiom_51_57 : (iT_ = iplus6_ \/ (iT_ = iminus2_ \/ iT_ = iplus9_)).
Variable axiom_52_58 : (iT_ = iplus2_ \/ (iT_ = iplus1_ \/ iT_ = iminus4_)).
Variable axiom_53_59 : (iT_ = iplus6_ \/ (iT_ = iminus4_ \/ iT_ = iminus1_)).
Variable axiom_54_60 : (iT_ = iminus5_ \/ (iT_ = iplus3_ \/ iT_ = iminus9_)).
Variable axiom_55_61 : (iT_ = iplus5_ \/ (iT_ = iplus2_ \/ iT_ = iplus9_)).
Variable axiom_56_62 : (iT_ = iminus6_ \/ (iT_ = iminus2_ \/ iT_ = iplus4_)).
Variable axiom_57_63 : (iT_ = iplus8_ \/ (iT_ = iplus6_ \/ iT_ = iminus4_)).
Variable axiom_58_64 : (iT_ = iminus4_ \/ (iT_ = iplus7_ \/ iT_ = iplus9_)).
Variable axiom_59_65 : cowlThing_ iminus1_.
Variable axiom_60_66 : cowlThing_ iminus2_.
Variable axiom_61_67 : cowlThing_ iminus3_.
Variable axiom_62_68 : cowlThing_ iminus4_.
Variable axiom_63_69 : cowlThing_ iminus5_.
Variable axiom_64_70 : cowlThing_ iminus6_.
Variable axiom_65_71 : cowlThing_ iminus7_.
Variable axiom_66_72 : cowlThing_ iminus8_.
Variable axiom_67_73 : cowlThing_ iminus9_.
Variable axiom_68_74 : cowlThing_ iplus1_.
Variable axiom_69_75 : cowlThing_ iplus2_.
Variable axiom_70_76 : cowlThing_ iplus3_.
Variable axiom_71_77 : cowlThing_ iplus4_.
Variable axiom_72_78 : cowlThing_ iplus5_.
Variable axiom_73_79 : cowlThing_ iplus6_.
Variable axiom_74_80 : cowlThing_ iplus7_.
Variable axiom_75_81 : cowlThing_ iplus8_.
Variable axiom_76_82 : cowlThing_ iplus9_.
Variable axiom_77_83 : iT_ <> iF_.

Theorem conjecture_84 : False.
Proof.
  time hprover.
Qed.

End FOFProblem.
