(*
% File     : KRS099+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : DL Test: heinsohn3c.1
% Version  : Especial.
% English  : Tbox tests from [HK+94]
% Refs     : [HK+94] Heinsohn et al. (1994), An Empirical Analysis of Termi
%          : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : inconsistent_description-logic-Manifest109 [Bec03]
% Status   : Unsatisfiable
% Rating   : 0.00 v3.1.0
% Status (intuit.) : Theorem (Problem negated)
% Rating (intuit.) : 0.75 v1.1.0
% Syntax   : Number of formulae    :   16 (   1 unit)
%            Number of atoms       :   55 (  15 equality)
%            Maximal formula depth :   13 (   5 average)
%            Number of connectives :   45 (   6 ~  ;   1  |;  21  &)
%                                         (   2 <=>;  15 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   10 (   0 propositional; 1-2 arity)
%            Number of functors    :    1 (   1 constant; 0-0 arity)
%            Number of variables   :   35 (   0 singleton;  32 !;   3 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
%          : Tests incoherency caused by number restrictions and role hierarchy
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable xsd_string_ : Universe -> Prop.
Variable xsd_integer_ : Universe -> Prop.
Variable rtt_ : Universe -> Universe -> Prop.
Variable cowlThing_ : Universe -> Prop.
Variable cowlNothing_ : Universe -> Prop.
Variable cd_ : Universe -> Prop.
Variable cc_ : Universe -> Prop.
Variable ca_ : Universe -> Prop.
Variable cUnsatisfiable_ : Universe -> Prop.

Variable i2003_11_14_17_20_29215_ : Universe.

Variable cUnsatisfiable_substitution_1_1 : (forall A B : Universe, ((A = B /\ cUnsatisfiable_ A) -> cUnsatisfiable_ B)).
Variable ca_substitution_1_2 : (forall A B : Universe, ((A = B /\ ca_ A) -> ca_ B)).
Variable cc_substitution_1_3 : (forall A B : Universe, ((A = B /\ cc_ A) -> cc_ B)).
Variable cd_substitution_1_4 : (forall A B : Universe, ((A = B /\ cd_ A) -> cd_ B)).
Variable cowlNothing_substitution_1_5 : (forall A B : Universe, ((A = B /\ cowlNothing_ A) -> cowlNothing_ B)).
Variable cowlThing_substitution_1_6 : (forall A B : Universe, ((A = B /\ cowlThing_ A) -> cowlThing_ B)).
Variable rtt_substitution_1_7 : (forall A B C : Universe, ((A = B /\ rtt_ A C) -> rtt_ B C)).
Variable rtt_substitution_2_8 : (forall A B C : Universe, ((A = B /\ rtt_ C A) -> rtt_ C B)).
Variable xsd_integer_substitution_1_9 : (forall A B : Universe, ((A = B /\ xsd_integer_ A) -> xsd_integer_ B)).
Variable xsd_string_substitution_1_10 : (forall A B : Universe, ((A = B /\ xsd_string_ A) -> xsd_string_ B)).
Variable axiom_0_11 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_12 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_13 : (forall X : Universe, (cUnsatisfiable_ X <-> ((exists Y0 Y1 Y2 : Universe, (rtt_ X Y0 /\ (rtt_ X Y1 /\ (rtt_ X Y2 /\ (Y0 <> Y1 /\ (Y0 <> Y2 /\ Y1 <> Y2)))))) /\ ((forall Y : Universe, (rtt_ X Y -> ca_ Y)) /\ ((forall Y0 Y1 : Universe, ((rtt_ X Y0 /\ rtt_ X Y1) -> Y0 = Y1)) /\ (forall Y0 Y1 : Universe, ((rtt_ X Y0 /\ rtt_ X Y1) -> Y0 = Y1))))))).
Variable axiom_3_14 : (forall X : Universe, (ca_ X -> (cd_ X \/ cc_ X))).
Variable axiom_4_15 : (forall X : Universe, (cc_ X -> ~(cd_ X))).
Variable axiom_5_16 : cUnsatisfiable_ i2003_11_14_17_20_29215_.

Theorem conjecture_17 : False.
Proof.
  time hprover.
Qed.

End FOFProblem.
