(*
% File     : KRS098+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : DL Test: heinsohn3.2
% Version  : Especial.
% English  : Tbox tests from [HK+94]
% Refs     : [HK+94] Heinsohn et al. (1994), An Empirical Analysis of Termi
%          : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : inconsistent_description-logic-Manifest108 [Bec03]
% Status   : Unsatisfiable
% Rating   : 0.00 v3.1.0
% Status (intuit.) : Open (Problem negated)
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :   39 (   1 unit)
%            Number of atoms       :  123 (  29 equality)
%            Maximal formula depth :   13 (   5 average)
%            Number of connectives :   91 (   7 ~  ;   1  |;  46  &)
%                                         (   3 <=>;  34 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   18 (   0 propositional; 1-2 arity)
%            Number of functors    :    1 (   1 constant; 0-0 arity)
%            Number of variables   :   99 (   0 singleton;  91 !;   8 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
%          : Tests incoherency caused by number restrictions and role hierarchy
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable xsd_string_ : Universe -> Prop.
Variable xsd_integer_ : Universe -> Prop.
Variable rtt_ : Universe -> Universe -> Prop.
Variable rt3_ : Universe -> Universe -> Prop.
Variable rt2_ : Universe -> Universe -> Prop.
Variable rt1_ : Universe -> Universe -> Prop.
Variable rr3_ : Universe -> Universe -> Prop.
Variable rr2_ : Universe -> Universe -> Prop.
Variable rr1_ : Universe -> Universe -> Prop.
Variable rr_ : Universe -> Universe -> Prop.
Variable cowlThing_ : Universe -> Prop.
Variable cowlNothing_ : Universe -> Prop.
Variable ce_ : Universe -> Prop.
Variable cd_ : Universe -> Prop.
Variable cc_ : Universe -> Prop.
Variable ca_ : Universe -> Prop.
Variable cUnsatisfiable_ : Universe -> Prop.

Variable i2003_11_14_17_20_25524_ : Universe.

Variable cUnsatisfiable_substitution_1_1 : (forall A B : Universe, ((A = B /\ cUnsatisfiable_ A) -> cUnsatisfiable_ B)).
Variable ca_substitution_1_2 : (forall A B : Universe, ((A = B /\ ca_ A) -> ca_ B)).
Variable cc_substitution_1_3 : (forall A B : Universe, ((A = B /\ cc_ A) -> cc_ B)).
Variable cd_substitution_1_4 : (forall A B : Universe, ((A = B /\ cd_ A) -> cd_ B)).
Variable ce_substitution_1_5 : (forall A B : Universe, ((A = B /\ ce_ A) -> ce_ B)).
Variable cowlNothing_substitution_1_6 : (forall A B : Universe, ((A = B /\ cowlNothing_ A) -> cowlNothing_ B)).
Variable cowlThing_substitution_1_7 : (forall A B : Universe, ((A = B /\ cowlThing_ A) -> cowlThing_ B)).
Variable rr_substitution_1_8 : (forall A B C : Universe, ((A = B /\ rr_ A C) -> rr_ B C)).
Variable rr_substitution_2_9 : (forall A B C : Universe, ((A = B /\ rr_ C A) -> rr_ C B)).
Variable rr1_substitution_1_10 : (forall A B C : Universe, ((A = B /\ rr1_ A C) -> rr1_ B C)).
Variable rr1_substitution_2_11 : (forall A B C : Universe, ((A = B /\ rr1_ C A) -> rr1_ C B)).
Variable rr2_substitution_1_12 : (forall A B C : Universe, ((A = B /\ rr2_ A C) -> rr2_ B C)).
Variable rr2_substitution_2_13 : (forall A B C : Universe, ((A = B /\ rr2_ C A) -> rr2_ C B)).
Variable rr3_substitution_1_14 : (forall A B C : Universe, ((A = B /\ rr3_ A C) -> rr3_ B C)).
Variable rr3_substitution_2_15 : (forall A B C : Universe, ((A = B /\ rr3_ C A) -> rr3_ C B)).
Variable rt1_substitution_1_16 : (forall A B C : Universe, ((A = B /\ rt1_ A C) -> rt1_ B C)).
Variable rt1_substitution_2_17 : (forall A B C : Universe, ((A = B /\ rt1_ C A) -> rt1_ C B)).
Variable rt2_substitution_1_18 : (forall A B C : Universe, ((A = B /\ rt2_ A C) -> rt2_ B C)).
Variable rt2_substitution_2_19 : (forall A B C : Universe, ((A = B /\ rt2_ C A) -> rt2_ C B)).
Variable rt3_substitution_1_20 : (forall A B C : Universe, ((A = B /\ rt3_ A C) -> rt3_ B C)).
Variable rt3_substitution_2_21 : (forall A B C : Universe, ((A = B /\ rt3_ C A) -> rt3_ C B)).
Variable rtt_substitution_1_22 : (forall A B C : Universe, ((A = B /\ rtt_ A C) -> rtt_ B C)).
Variable rtt_substitution_2_23 : (forall A B C : Universe, ((A = B /\ rtt_ C A) -> rtt_ C B)).
Variable xsd_integer_substitution_1_24 : (forall A B : Universe, ((A = B /\ xsd_integer_ A) -> xsd_integer_ B)).
Variable xsd_string_substitution_1_25 : (forall A B : Universe, ((A = B /\ xsd_string_ A) -> xsd_string_ B)).
Variable axiom_0_26 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_27 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_28 : (forall X : Universe, (cUnsatisfiable_ X <-> ((exists Y : Universe, (rr3_ X Y /\ ((exists Z : Universe, (rt3_ Y Z /\ ce_ Z)) /\ (forall Z0 Z1 : Universe, ((rtt_ Y Z0 /\ rtt_ Y Z1) -> Z0 = Z1))))) /\ ((exists Y : Universe, (rr2_ X Y /\ ((forall Z0 Z1 : Universe, ((rtt_ Y Z0 /\ rtt_ Y Z1) -> Z0 = Z1)) /\ (exists Z : Universe, (rt2_ Y Z /\ cd_ Z))))) /\ (~((exists Y0 Y1 : Universe, (rr_ X Y0 /\ (rr_ X Y1 /\ Y0 <> Y1)))) /\ (exists Y : Universe, (rr1_ X Y /\ ((forall Z0 Z1 : Universe, ((rtt_ Y Z0 /\ rtt_ Y Z1) -> Z0 = Z1)) /\ (exists Z : Universe, (rt1_ Y Z /\ cc_ Z)))))))))).
Variable axiom_3_29 : (forall X : Universe, (ca_ X <-> (cc_ X \/ cd_ X))).
Variable axiom_4_30 : cUnsatisfiable_ i2003_11_14_17_20_25524_.
Variable axiom_5_31 : (forall X : Universe, ~((cc_ X /\ cd_ X))).
Variable axiom_6_32 : (forall X : Universe, ~((ce_ X /\ cc_ X))).
Variable axiom_7_33 : (forall X : Universe, ~((ce_ X /\ cd_ X))).
Variable axiom_8_34 : (forall X Y : Universe, (rr1_ X Y -> rr_ X Y)).
Variable axiom_9_35 : (forall X Y : Universe, (rr2_ X Y -> rr_ X Y)).
Variable axiom_10_36 : (forall X Y : Universe, (rt1_ X Y -> rtt_ X Y)).
Variable axiom_11_37 : (forall X Y : Universe, (rt2_ X Y -> rtt_ X Y)).
Variable axiom_12_38 : (forall X Y : Universe, (rr3_ X Y -> rr_ X Y)).
Variable axiom_13_39 : (forall X Y : Universe, (rt3_ X Y -> rtt_ X Y)).

Theorem conjecture_40 : False.
Proof.
  time hprover.
Qed.

End FOFProblem.
