(*
% File     : KRS089+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : A test for the interaction of one-of and inverse 
% Version  : Especial.
% English  : A test for the interaction of one-of and inverse using the idea 
%            of a spy point. Everything is related to the spy via the property 
%            p and we know that the spy has at most two invP successors, thus 
%            limiting the cardinality of the domain to being at most 2.
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : inconsistent_description-logic-Manifest035 [Bec03]
% Status   : Unsatisfiable
% Rating   : 0.00 v3.1.0
% Status (intuit.) : Open (Problem negated)
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :   19 (   2 unit)
%            Number of atoms       :   57 (  18 equality)
%            Maximal formula depth :   12 (   5 average)
%            Number of connectives :   43 (   5 ~  ;   2  |;  20  &)
%                                         (   2 <=>;  14 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    9 (   0 propositional; 1-2 arity)
%            Number of functors    :    2 (   2 constant; 0-0 arity)
%            Number of variables   :   41 (   0 singleton;  37 !;   4 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable xsd_string_ : Universe -> Prop.
Variable xsd_integer_ : Universe -> Prop.
Variable rr_ : Universe -> Universe -> Prop.
Variable rp_ : Universe -> Universe -> Prop.
Variable rinvP_ : Universe -> Universe -> Prop.
Variable cowlThing_ : Universe -> Prop.
Variable cowlNothing_ : Universe -> Prop.
Variable cUnsatisfiable_ : Universe -> Prop.

Variable ispy_ : Universe.
Variable i2003_11_14_17_19_53168_ : Universe.

Variable cUnsatisfiable_substitution_1_1 : (forall A B : Universe, ((A = B /\ cUnsatisfiable_ A) -> cUnsatisfiable_ B)).
Variable cowlNothing_substitution_1_2 : (forall A B : Universe, ((A = B /\ cowlNothing_ A) -> cowlNothing_ B)).
Variable cowlThing_substitution_1_3 : (forall A B : Universe, ((A = B /\ cowlThing_ A) -> cowlThing_ B)).
Variable rinvP_substitution_1_4 : (forall A B C : Universe, ((A = B /\ rinvP_ A C) -> rinvP_ B C)).
Variable rinvP_substitution_2_5 : (forall A B C : Universe, ((A = B /\ rinvP_ C A) -> rinvP_ C B)).
Variable rp_substitution_1_6 : (forall A B C : Universe, ((A = B /\ rp_ A C) -> rp_ B C)).
Variable rp_substitution_2_7 : (forall A B C : Universe, ((A = B /\ rp_ C A) -> rp_ C B)).
Variable rr_substitution_1_8 : (forall A B C : Universe, ((A = B /\ rr_ A C) -> rr_ B C)).
Variable rr_substitution_2_9 : (forall A B C : Universe, ((A = B /\ rr_ C A) -> rr_ C B)).
Variable xsd_integer_substitution_1_10 : (forall A B : Universe, ((A = B /\ xsd_integer_ A) -> xsd_integer_ B)).
Variable xsd_string_substitution_1_11 : (forall A B : Universe, ((A = B /\ xsd_string_ A) -> xsd_string_ B)).
Variable axiom_0_12 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_13 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_14 : (forall X : Universe, (cUnsatisfiable_ X -> (exists Y0 Y1 Y2 : Universe, (rr_ X Y0 /\ (rr_ X Y1 /\ (rr_ X Y2 /\ (Y0 <> Y1 /\ (Y0 <> Y2 /\ Y1 <> Y2)))))))).
Variable axiom_3_15 : (forall X : Universe, (cowlThing_ X -> (exists Y : Universe, (rp_ X Y /\ Y = ispy_)))).
Variable axiom_4_16 : (forall X Y : Universe, (rp_ X Y <-> rinvP_ Y X)).
Variable axiom_5_17 : (forall X0 X1 X2 : Universe, ((rinvP_ ispy_ X0 /\ (rinvP_ ispy_ X1 /\ rinvP_ ispy_ X2)) -> (X0 = X1 \/ (X0 = X2 \/ X1 = X2)))).
Variable axiom_6_18 : cowlThing_ ispy_.
Variable axiom_7_19 : cUnsatisfiable_ i2003_11_14_17_19_53168_.

Theorem conjecture_20 : False.
Proof.
  time hprover.
Qed.

End FOFProblem.
