(*
% File     : KRS083+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : DL Test: t6.1 Double blocking example
% Version  : Especial.
% English  : 
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : inconsistent_description-logic-Manifest026 [Bec03]
% Status   : Unsatisfiable
% Rating   : 0.00 v3.1.0
% Status (intuit.) : Open (Problem negated)
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :   25 (   1 unit)
%            Number of atoms       :   74 (  16 equality)
%            Maximal formula depth :    8 (   5 average)
%            Number of connectives :   53 (   4 ~  ;   0  |;  24  &)
%                                         (   5 <=>;  20 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   12 (   0 propositional; 1-2 arity)
%            Number of functors    :    1 (   1 constant; 0-0 arity)
%            Number of variables   :   58 (   0 singleton;  55 !;   3 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
%          : The concept should be incoherent but needs double blocking
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable xsd_string_ : Universe -> Prop.
Variable xsd_integer_ : Universe -> Prop.
Variable rr_ : Universe -> Universe -> Prop.
Variable rinvR_ : Universe -> Universe -> Prop.
Variable rinvF_ : Universe -> Universe -> Prop.
Variable rf_ : Universe -> Universe -> Prop.
Variable cowlThing_ : Universe -> Prop.
Variable cowlNothing_ : Universe -> Prop.
Variable cd_ : Universe -> Prop.
Variable cc_ : Universe -> Prop.
Variable cUnsatisfiable_ : Universe -> Prop.

Variable i2003_11_14_17_19_32337_ : Universe.

Variable cUnsatisfiable_substitution_1_1 : (forall A B : Universe, ((A = B /\ cUnsatisfiable_ A) -> cUnsatisfiable_ B)).
Variable cc_substitution_1_2 : (forall A B : Universe, ((A = B /\ cc_ A) -> cc_ B)).
Variable cd_substitution_1_3 : (forall A B : Universe, ((A = B /\ cd_ A) -> cd_ B)).
Variable cowlNothing_substitution_1_4 : (forall A B : Universe, ((A = B /\ cowlNothing_ A) -> cowlNothing_ B)).
Variable cowlThing_substitution_1_5 : (forall A B : Universe, ((A = B /\ cowlThing_ A) -> cowlThing_ B)).
Variable rf_substitution_1_6 : (forall A B C : Universe, ((A = B /\ rf_ A C) -> rf_ B C)).
Variable rf_substitution_2_7 : (forall A B C : Universe, ((A = B /\ rf_ C A) -> rf_ C B)).
Variable rinvF_substitution_1_8 : (forall A B C : Universe, ((A = B /\ rinvF_ A C) -> rinvF_ B C)).
Variable rinvF_substitution_2_9 : (forall A B C : Universe, ((A = B /\ rinvF_ C A) -> rinvF_ C B)).
Variable rinvR_substitution_1_10 : (forall A B C : Universe, ((A = B /\ rinvR_ A C) -> rinvR_ B C)).
Variable rinvR_substitution_2_11 : (forall A B C : Universe, ((A = B /\ rinvR_ C A) -> rinvR_ C B)).
Variable rr_substitution_1_12 : (forall A B C : Universe, ((A = B /\ rr_ A C) -> rr_ B C)).
Variable rr_substitution_2_13 : (forall A B C : Universe, ((A = B /\ rr_ C A) -> rr_ C B)).
Variable xsd_integer_substitution_1_14 : (forall A B : Universe, ((A = B /\ xsd_integer_ A) -> xsd_integer_ B)).
Variable xsd_string_substitution_1_15 : (forall A B : Universe, ((A = B /\ xsd_string_ A) -> xsd_string_ B)).
Variable axiom_0_16 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_17 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_18 : (forall X : Universe, (cUnsatisfiable_ X <-> ((forall Y : Universe, (rinvR_ X Y -> (exists Z : Universe, (rinvF_ Y Z /\ cd_ Z)))) /\ (~(cc_ X) /\ (exists Y : Universe, (rinvF_ X Y /\ cd_ Y)))))).
Variable axiom_3_19 : (forall X : Universe, (cd_ X <-> ((exists Y : Universe, (rf_ X Y /\ ~(cc_ Y))) /\ cc_ X))).
Variable axiom_4_20 : (forall X : Universe, (cowlThing_ X -> (forall Y0 Y1 : Universe, ((rf_ X Y0 /\ rf_ X Y1) -> Y0 = Y1)))).
Variable axiom_5_21 : (forall X Y : Universe, (rinvF_ X Y <-> rf_ Y X)).
Variable axiom_6_22 : (forall X Y : Universe, (rinvR_ X Y <-> rr_ Y X)).
Variable axiom_7_23 : (forall X Y Z : Universe, ((rr_ X Y /\ rr_ Y Z) -> rr_ X Z)).
Variable axiom_8_24 : cUnsatisfiable_ i2003_11_14_17_19_32337_.
Variable axiom_9_25 : (forall X Y : Universe, (rf_ X Y -> rr_ X Y)).

Theorem conjecture_26 : False.
Proof.
  time hprover.
Qed.

End FOFProblem.
