(*
% File     : KRS082+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : DL Test: t4.1 Dynamic blocking example
% Version  : Especial.
% English  : 
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : inconsistent_description-logic-Manifest023 [Bec03]
% Status   : Unsatisfiable
% Rating   : 0.00 v3.1.0
% Status (intuit.) : Theorem (Problem negated)
% Rating (intuit.) : 0.50 v1.1.0
% Syntax   : Number of formulae    :   10 (   1 unit)
%            Number of atoms       :   38 (   0 equality)
%            Maximal formula depth :   14 (   5 average)
%            Number of connectives :   31 (   3 ~  ;   0  |;  12  &)
%                                         (   5 <=>;  11 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   13 (   0 propositional; 1-2 arity)
%            Number of functors    :    1 (   1 constant; 0-0 arity)
%            Number of variables   :   27 (   0 singleton;  22 !;   5 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable xsd_string_ : Universe -> Prop.
Variable xsd_integer_ : Universe -> Prop.
Variable rs_ : Universe -> Universe -> Prop.
Variable rr_ : Universe -> Universe -> Prop.
Variable rp_ : Universe -> Universe -> Prop.
Variable rinvS_ : Universe -> Universe -> Prop.
Variable rinvR_ : Universe -> Universe -> Prop.
Variable rinvP_ : Universe -> Universe -> Prop.
Variable cowlThing_ : Universe -> Prop.
Variable cowlNothing_ : Universe -> Prop.
Variable cc_ : Universe -> Prop.
Variable ca_ : Universe -> Prop.
Variable cUnsatisfiable_ : Universe -> Prop.

Variable i2003_11_14_17_19_28752_ : Universe.

Variable axiom_0_1 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_2 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_3 : (forall X : Universe, (cUnsatisfiable_ X -> (exists Y : Universe, (rs_ X Y /\ ((exists Z : Universe, (rp_ Y Z /\ cowlThing_ Z)) /\ ((forall Z : Universe, (rr_ Y Z -> cc_ Z)) /\ ((forall Z : Universe, (rp_ Y Z -> (exists W : Universe, (rr_ Z W /\ cowlThing_ W)))) /\ ((forall Z : Universe, (rp_ Y Z -> (exists W : Universe, (rp_ Z W /\ cowlThing_ W)))) /\ ((forall Z : Universe, (rp_ Y Z -> (forall W : Universe, (rr_ Z W -> cc_ W)))) /\ (exists Z : Universe, (rr_ Y Z /\ cowlThing_ Z))))))))))).
Variable axiom_3_4 : (forall X : Universe, (cUnsatisfiable_ X -> ca_ X)).
Variable axiom_4_5 : (forall X : Universe, (cc_ X <-> (forall Y : Universe, (rinvR_ X Y -> (forall Z : Universe, (rinvP_ Y Z -> (forall W : Universe, (rinvS_ Z W -> ~(ca_ W))))))))).
Variable axiom_5_6 : (forall X Y : Universe, (rinvP_ X Y <-> rp_ Y X)).
Variable axiom_6_7 : (forall X Y : Universe, (rinvR_ X Y <-> rr_ Y X)).
Variable axiom_7_8 : (forall X Y : Universe, (rinvS_ X Y <-> rs_ Y X)).
Variable axiom_8_9 : (forall X Y Z : Universe, ((rp_ X Y /\ rp_ Y Z) -> rp_ X Z)).
Variable axiom_9_10 : cUnsatisfiable_ i2003_11_14_17_19_28752_.

Theorem conjecture_11 : False.
Proof.
  time hprover.
Qed.

End FOFProblem.
