(*
% File     : KRS081+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : DL Test: t3a.3
% Version  : Especial.
% English  : 
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : inconsistent_description-logic-Manifest022 [Bec03]
% Status   : Unsatisfiable
% Rating   : 0.00 v3.1.0
% Status (intuit.) : Open (Problem negated)
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :   21 (   1 unit)
%            Number of atoms       :   96 (  23 equality)
%            Maximal formula depth :   26 (   6 average)
%            Number of connectives :   81 (   6 ~  ;  15  |;  40  &)
%                                         (   2 <=>;  18 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   13 (   0 propositional; 1-2 arity)
%            Number of functors    :    1 (   1 constant; 0-0 arity)
%            Number of variables   :   49 (   0 singleton;  40 !;   9 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
%          : There are 42,525 possible partitions in the satisfiable case
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable xsd_string_ : Universe -> Prop.
Variable xsd_integer_ : Universe -> Prop.
Variable rr_ : Universe -> Universe -> Prop.
Variable cp5_ : Universe -> Prop.
Variable cp4_ : Universe -> Prop.
Variable cp3_ : Universe -> Prop.
Variable cp2_ : Universe -> Prop.
Variable cp1_ : Universe -> Prop.
Variable cp_ : Universe -> Prop.
Variable cowlThing_ : Universe -> Prop.
Variable cowlNothing_ : Universe -> Prop.
Variable cUnsatisfiable_ : Universe -> Prop.

Variable i2003_11_14_17_19_24236_ : Universe.

Variable cUnsatisfiable_substitution_1_1 : (forall A B : Universe, ((A = B /\ cUnsatisfiable_ A) -> cUnsatisfiable_ B)).
Variable cowlNothing_substitution_1_2 : (forall A B : Universe, ((A = B /\ cowlNothing_ A) -> cowlNothing_ B)).
Variable cowlThing_substitution_1_3 : (forall A B : Universe, ((A = B /\ cowlThing_ A) -> cowlThing_ B)).
Variable cp_substitution_1_4 : (forall A B : Universe, ((A = B /\ cp_ A) -> cp_ B)).
Variable cp1_substitution_1_5 : (forall A B : Universe, ((A = B /\ cp1_ A) -> cp1_ B)).
Variable cp2_substitution_1_6 : (forall A B : Universe, ((A = B /\ cp2_ A) -> cp2_ B)).
Variable cp3_substitution_1_7 : (forall A B : Universe, ((A = B /\ cp3_ A) -> cp3_ B)).
Variable cp4_substitution_1_8 : (forall A B : Universe, ((A = B /\ cp4_ A) -> cp4_ B)).
Variable cp5_substitution_1_9 : (forall A B : Universe, ((A = B /\ cp5_ A) -> cp5_ B)).
Variable rr_substitution_1_10 : (forall A B C : Universe, ((A = B /\ rr_ A C) -> rr_ B C)).
Variable rr_substitution_2_11 : (forall A B C : Universe, ((A = B /\ rr_ C A) -> rr_ C B)).
Variable xsd_integer_substitution_1_12 : (forall A B : Universe, ((A = B /\ xsd_integer_ A) -> xsd_integer_ B)).
Variable xsd_string_substitution_1_13 : (forall A B : Universe, ((A = B /\ xsd_string_ A) -> xsd_string_ B)).
Variable axiom_0_14 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_15 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_16 : (forall X : Universe, (cUnsatisfiable_ X <-> ((exists Y : Universe, (rr_ X Y /\ cp3_ Y)) /\ ((exists Y : Universe, (rr_ X Y /\ (cp4_ Y /\ cp_ Y))) /\ ((exists Y : Universe, (rr_ X Y /\ cp4_ Y)) /\ ((exists Y : Universe, (rr_ X Y /\ (cp2_ Y /\ cp_ Y))) /\ ((exists Y : Universe, (rr_ X Y /\ cp5_ Y)) /\ ((exists Y : Universe, (rr_ X Y /\ (cp_ Y /\ cp3_ Y))) /\ ((exists Y : Universe, (rr_ X Y /\ cp1_ Y)) /\ ((forall Y0 Y1 Y2 Y3 Y4 : Universe, ((rr_ X Y0 /\ (rr_ X Y1 /\ (rr_ X Y2 /\ (rr_ X Y3 /\ rr_ X Y4)))) -> (Y0 = Y1 \/ (Y0 = Y2 \/ (Y0 = Y3 \/ (Y0 = Y4 \/ (Y1 = Y2 \/ (Y1 = Y3 \/ (Y1 = Y4 \/ (Y2 = Y3 \/ (Y2 = Y4 \/ Y3 = Y4))))))))))) /\ ((exists Y : Universe, (rr_ X Y /\ (cp1_ Y /\ cp_ Y))) /\ (exists Y : Universe, (rr_ X Y /\ cp2_ Y))))))))))))).
Variable axiom_3_17 : (forall X : Universe, (cp1_ X -> ~((cp2_ X \/ (cp4_ X \/ (cp5_ X \/ cp3_ X)))))).
Variable axiom_4_18 : (forall X : Universe, (cp2_ X -> ~((cp4_ X \/ (cp5_ X \/ cp3_ X))))).
Variable axiom_5_19 : (forall X : Universe, (cp3_ X -> ~((cp4_ X \/ cp5_ X)))).
Variable axiom_6_20 : (forall X : Universe, (cp4_ X -> ~(cp5_ X))).
Variable axiom_7_21 : cUnsatisfiable_ i2003_11_14_17_19_24236_.

Theorem conjecture_22 : False.
Proof.
  time hprover.
Qed.

End FOFProblem.
