(*
% File     : KRS078+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : DL Test: t12.1
% Version  : Especial.
% English  : 
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : inconsistent_description-logic-Manifest015 [Bec03]
% Status   : Unsatisfiable
% Rating   : 0.00 v3.1.0
% Status (intuit.) : Open (Problem negated)
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :   18 (   1 unit)
%            Number of atoms       :   57 (  14 equality)
%            Maximal formula depth :   11 (   5 average)
%            Number of connectives :   43 (   4 ~  ;   0  |;  21  &)
%                                         (   3 <=>;  15 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   11 (   0 propositional; 1-2 arity)
%            Number of functors    :    1 (   1 constant; 0-0 arity)
%            Number of variables   :   43 (   0 singleton;  40 !;   3 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable xsd_string_ : Universe -> Prop.
Variable xsd_integer_ : Universe -> Prop.
Variable rs_ : Universe -> Universe -> Prop.
Variable rr_ : Universe -> Universe -> Prop.
Variable rinvR_ : Universe -> Universe -> Prop.
Variable cq_ : Universe -> Prop.
Variable cp_ : Universe -> Prop.
Variable cowlThing_ : Universe -> Prop.
Variable cowlNothing_ : Universe -> Prop.
Variable cUnsatisfiable_ : Universe -> Prop.

Variable i2003_11_14_17_19_13721_ : Universe.

Variable cUnsatisfiable_substitution_1_1 : (forall A B : Universe, ((A = B /\ cUnsatisfiable_ A) -> cUnsatisfiable_ B)).
Variable cowlNothing_substitution_1_2 : (forall A B : Universe, ((A = B /\ cowlNothing_ A) -> cowlNothing_ B)).
Variable cowlThing_substitution_1_3 : (forall A B : Universe, ((A = B /\ cowlThing_ A) -> cowlThing_ B)).
Variable cp_substitution_1_4 : (forall A B : Universe, ((A = B /\ cp_ A) -> cp_ B)).
Variable cq_substitution_1_5 : (forall A B : Universe, ((A = B /\ cq_ A) -> cq_ B)).
Variable rinvR_substitution_1_6 : (forall A B C : Universe, ((A = B /\ rinvR_ A C) -> rinvR_ B C)).
Variable rinvR_substitution_2_7 : (forall A B C : Universe, ((A = B /\ rinvR_ C A) -> rinvR_ C B)).
Variable rr_substitution_1_8 : (forall A B C : Universe, ((A = B /\ rr_ A C) -> rr_ B C)).
Variable rr_substitution_2_9 : (forall A B C : Universe, ((A = B /\ rr_ C A) -> rr_ C B)).
Variable rs_substitution_1_10 : (forall A B C : Universe, ((A = B /\ rs_ A C) -> rs_ B C)).
Variable rs_substitution_2_11 : (forall A B C : Universe, ((A = B /\ rs_ C A) -> rs_ C B)).
Variable xsd_integer_substitution_1_12 : (forall A B : Universe, ((A = B /\ xsd_integer_ A) -> xsd_integer_ B)).
Variable xsd_string_substitution_1_13 : (forall A B : Universe, ((A = B /\ xsd_string_ A) -> xsd_string_ B)).
Variable axiom_0_14 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_15 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_16 : (forall X : Universe, (cUnsatisfiable_ X <-> ((exists Y : Universe, (rr_ X Y /\ ((exists Z : Universe, (rinvR_ Y Z /\ (forall W : Universe, (rs_ Z W -> cp_ W)))) /\ (forall Z0 Z1 : Universe, ((rinvR_ Y Z0 /\ rinvR_ Y Z1) -> Z0 = Z1))))) /\ (exists Y : Universe, (rs_ X Y /\ (~(cq_ Y) /\ ~(cp_ Y))))))).
Variable axiom_3_17 : (forall X Y : Universe, (rinvR_ X Y <-> rr_ Y X)).
Variable axiom_4_18 : cUnsatisfiable_ i2003_11_14_17_19_13721_.

Theorem conjecture_19 : False.
Proof.
  time hprover.
Qed.

End FOFProblem.
