(*
% File     : KRS077+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : DL Test: t11.1
% Version  : Especial.
% English  : 
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : inconsistent_description-logic-Manifest014 [Bec03]
% Status   : Unsatisfiable
% Rating   : 0.00 v3.1.0
% Status (intuit.) : Open (Problem negated)
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :   18 (   1 unit)
%            Number of atoms       :   55 (  13 equality)
%            Maximal formula depth :    9 (   5 average)
%            Number of connectives :   40 (   3 ~  ;   0  |;  19  &)
%                                         (   3 <=>;  15 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   10 (   0 propositional; 1-2 arity)
%            Number of functors    :    1 (   1 constant; 0-0 arity)
%            Number of variables   :   42 (   0 singleton;  40 !;   2 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable xsd_string_ : Universe -> Prop.
Variable xsd_integer_ : Universe -> Prop.
Variable rs_ : Universe -> Universe -> Prop.
Variable rr_ : Universe -> Universe -> Prop.
Variable rinvS_ : Universe -> Universe -> Prop.
Variable cp_ : Universe -> Prop.
Variable cowlThing_ : Universe -> Prop.
Variable cowlNothing_ : Universe -> Prop.
Variable cUnsatisfiable_ : Universe -> Prop.

Variable i2003_11_14_17_19_09372_ : Universe.

Variable cUnsatisfiable_substitution_1_1 : (forall A B : Universe, ((A = B /\ cUnsatisfiable_ A) -> cUnsatisfiable_ B)).
Variable cowlNothing_substitution_1_2 : (forall A B : Universe, ((A = B /\ cowlNothing_ A) -> cowlNothing_ B)).
Variable cowlThing_substitution_1_3 : (forall A B : Universe, ((A = B /\ cowlThing_ A) -> cowlThing_ B)).
Variable cp_substitution_1_4 : (forall A B : Universe, ((A = B /\ cp_ A) -> cp_ B)).
Variable rinvS_substitution_1_5 : (forall A B C : Universe, ((A = B /\ rinvS_ A C) -> rinvS_ B C)).
Variable rinvS_substitution_2_6 : (forall A B C : Universe, ((A = B /\ rinvS_ C A) -> rinvS_ C B)).
Variable rr_substitution_1_7 : (forall A B C : Universe, ((A = B /\ rr_ A C) -> rr_ B C)).
Variable rr_substitution_2_8 : (forall A B C : Universe, ((A = B /\ rr_ C A) -> rr_ C B)).
Variable rs_substitution_1_9 : (forall A B C : Universe, ((A = B /\ rs_ A C) -> rs_ B C)).
Variable rs_substitution_2_10 : (forall A B C : Universe, ((A = B /\ rs_ C A) -> rs_ C B)).
Variable xsd_integer_substitution_1_11 : (forall A B : Universe, ((A = B /\ xsd_integer_ A) -> xsd_integer_ B)).
Variable xsd_string_substitution_1_12 : (forall A B : Universe, ((A = B /\ xsd_string_ A) -> xsd_string_ B)).
Variable axiom_0_13 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_14 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_15 : (forall X : Universe, (cUnsatisfiable_ X <-> ((forall Y0 Y1 : Universe, ((rr_ X Y0 /\ rr_ X Y1) -> Y0 = Y1)) /\ ((exists Y : Universe, (rr_ X Y /\ (forall Z : Universe, (rinvS_ Y Z -> cp_ Z)))) /\ (~(cp_ X) /\ (exists Y : Universe, (rs_ X Y /\ cp_ Y))))))).
Variable axiom_3_16 : (forall X Y : Universe, (rinvS_ X Y <-> rs_ Y X)).
Variable axiom_4_17 : cUnsatisfiable_ i2003_11_14_17_19_09372_.
Variable axiom_5_18 : (forall X Y : Universe, (rs_ X Y -> rr_ X Y)).

Theorem conjecture_19 : False.
Proof.
  time hprover.
Qed.

End FOFProblem.
