(*
% File     : KRS067+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : DL Test: fact1.1
% Version  : Especial.
% English  : If a, b and c are disjoint, then: 
%                (a and b) or (b and c) or (c and a)
%            is unsatisfiable.
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : inconsistent_description-logic-Manifest001 [Bec03]
% Status   : Unsatisfiable
% Rating   : 0.00 v3.1.0
% Status (intuit.) : Theorem (Problem negated)
% Rating (intuit.) : 0.25 v1.1.0
% Syntax   : Number of formulae    :    6 (   1 unit)
%            Number of atoms       :   17 (   0 equality)
%            Maximal formula depth :    6 (   4 average)
%            Number of connectives :   15 (   4 ~  ;   3  |;   4  &)
%                                         (   2 <=>;   2 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    8 (   0 propositional; 1-1 arity)
%            Number of functors    :    1 (   1 constant; 0-0 arity)
%            Number of variables   :    5 (   0 singleton;   5 !;   0 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable xsd_string_ : Universe -> Prop.
Variable xsd_integer_ : Universe -> Prop.
Variable cowlThing_ : Universe -> Prop.
Variable cowlNothing_ : Universe -> Prop.
Variable cc_ : Universe -> Prop.
Variable cb_ : Universe -> Prop.
Variable ca_ : Universe -> Prop.
Variable cUnsatisfiable_ : Universe -> Prop.

Variable i2003_11_14_17_18_1956_ : Universe.

Variable axiom_0_1 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_2 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_3 : (forall X : Universe, (cUnsatisfiable_ X <-> ((cc_ X /\ cb_ X) \/ ((cb_ X /\ ca_ X) \/ (cc_ X /\ ca_ X))))).
Variable axiom_3_4 : (forall X : Universe, (ca_ X -> ~((cc_ X \/ cb_ X)))).
Variable axiom_4_5 : (forall X : Universe, (cb_ X -> ~(cc_ X))).
Variable axiom_5_6 : cUnsatisfiable_ i2003_11_14_17_18_1956_.

Theorem conjecture_7 : False.
Proof.
  time hprover.
Qed.

End FOFProblem.
