(*
% File     : KRS063+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : An example combining owl:oneOf and owl:inverseOf
% Version  : Especial.
% English  : 
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : inconsistent_I4.5-Manifest002 [Bec03]
% Status   : Unsatisfiable
% Rating   : 0.00 v3.1.0
% Status (intuit.) : Theorem (Problem negated)
% Rating (intuit.) : 0.75 v1.1.0
% Syntax   : Number of formulae    :   27 (   9 unit)
%            Number of atoms       :   63 (  18 equality)
%            Maximal formula depth :    8 (   4 average)
%            Number of connectives :   39 (   3 ~  ;   5  |;  14  &)
%                                         (   4 <=>;  13 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   11 (   0 propositional; 1-2 arity)
%            Number of functors    :    7 (   7 constant; 0-0 arity)
%            Number of variables   :   37 (   0 singleton;  36 !;   1 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable xsd_string_ : Universe -> Prop.
Variable xsd_integer_ : Universe -> Prop.
Variable risEuroMPFrom_ : Universe -> Universe -> Prop.
Variable rhasEuroMP_ : Universe -> Universe -> Prop.
Variable cowlThing_ : Universe -> Prop.
Variable cowlNothing_ : Universe -> Prop.
Variable cPerson_ : Universe -> Prop.
Variable cEuropeanCountry_ : Universe -> Prop.
Variable cEuroMP_ : Universe -> Prop.
Variable cEUCountry_ : Universe -> Prop.

Variable iUK_ : Universe.
Variable iPT_ : Universe.
Variable iNL_ : Universe.
Variable iKinnock_ : Universe.
Variable iFR_ : Universe.
Variable iES_ : Universe.
Variable iBE_ : Universe.

Variable cEUCountry_substitution_1_1 : (forall A B : Universe, ((A = B /\ cEUCountry_ A) -> cEUCountry_ B)).
Variable cEuroMP_substitution_1_2 : (forall A B : Universe, ((A = B /\ cEuroMP_ A) -> cEuroMP_ B)).
Variable cEuropeanCountry_substitution_1_3 : (forall A B : Universe, ((A = B /\ cEuropeanCountry_ A) -> cEuropeanCountry_ B)).
Variable cPerson_substitution_1_4 : (forall A B : Universe, ((A = B /\ cPerson_ A) -> cPerson_ B)).
Variable cowlNothing_substitution_1_5 : (forall A B : Universe, ((A = B /\ cowlNothing_ A) -> cowlNothing_ B)).
Variable cowlThing_substitution_1_6 : (forall A B : Universe, ((A = B /\ cowlThing_ A) -> cowlThing_ B)).
Variable rhasEuroMP_substitution_1_7 : (forall A B C : Universe, ((A = B /\ rhasEuroMP_ A C) -> rhasEuroMP_ B C)).
Variable rhasEuroMP_substitution_2_8 : (forall A B C : Universe, ((A = B /\ rhasEuroMP_ C A) -> rhasEuroMP_ C B)).
Variable risEuroMPFrom_substitution_1_9 : (forall A B C : Universe, ((A = B /\ risEuroMPFrom_ A C) -> risEuroMPFrom_ B C)).
Variable risEuroMPFrom_substitution_2_10 : (forall A B C : Universe, ((A = B /\ risEuroMPFrom_ C A) -> risEuroMPFrom_ C B)).
Variable xsd_integer_substitution_1_11 : (forall A B : Universe, ((A = B /\ xsd_integer_ A) -> xsd_integer_ B)).
Variable xsd_string_substitution_1_12 : (forall A B : Universe, ((A = B /\ xsd_string_ A) -> xsd_string_ B)).
Variable axiom_0_13 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_14 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_15 : (forall X : Universe, (cEUCountry_ X <-> (X = iPT_ \/ (X = iBE_ \/ (X = iNL_ \/ (X = iES_ \/ (X = iFR_ \/ X = iUK_))))))).
Variable axiom_3_16 : (forall X : Universe, (cEuroMP_ X <-> (exists Y : Universe, (risEuroMPFrom_ X Y /\ cowlThing_ Y)))).
Variable axiom_4_17 : (forall X Y : Universe, (rhasEuroMP_ X Y -> cEUCountry_ X)).
Variable axiom_5_18 : (forall X Y : Universe, (risEuroMPFrom_ X Y <-> rhasEuroMP_ Y X)).
Variable axiom_6_19 : cEuropeanCountry_ iBE_.
Variable axiom_7_20 : cEuropeanCountry_ iES_.
Variable axiom_8_21 : cEuropeanCountry_ iFR_.
Variable axiom_9_22 : cPerson_ iKinnock_.
Variable axiom_10_23 : ~(cEuroMP_ iKinnock_).
Variable axiom_11_24 : cEuropeanCountry_ iNL_.
Variable axiom_12_25 : cEuropeanCountry_ iPT_.
Variable axiom_13_26 : cEuropeanCountry_ iUK_.
Variable axiom_14_27 : rhasEuroMP_ iUK_ iKinnock_.

Theorem conjecture_28 : False.
Proof.
  time hprover.
Qed.

End FOFProblem.
