(*
% File     : KRS057+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : A possible mapping of the EquivalentClasses axiom
% Version  : Especial.
% English  : A possible mapping of the EquivalentClasses axiom, which is 
%            connected but without a Hamiltonian path.
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : consistent_equivalentClass-Manifest009 [Bec03]
% Status   : Satisfiable
% Rating   : 0.00 v3.1.0
% Status (intuit.) : Unsolved (Problem negated)
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :   11 (   1 unit)
%            Number of atoms       :   38 (  10 equality)
%            Maximal formula depth :    9 (   5 average)
%            Number of connectives :   32 (   5 ~  ;   0  |;  13  &)
%                                         (   7 <=>;   7 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    8 (   0 propositional; 1-2 arity)
%            Number of functors    :    1 (   1 constant; 0-0 arity)
%            Number of variables   :   17 (   0 singleton;  17 !;   0 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable xsd_string_ : Universe -> Prop.
Variable xsd_integer_ : Universe -> Prop.
Variable cowlThing_ : Universe -> Prop.
Variable cowlNothing_ : Universe -> Prop.
Variable cD_ : Universe -> Prop.
Variable cC_ : Universe -> Prop.
Variable cB_ : Universe -> Prop.

Variable iA_ : Universe.

Variable cB_substitution_1_1 : (forall A B : Universe, ((A = B /\ cB_ A) -> cB_ B)).
Variable cC_substitution_1_2 : (forall A B : Universe, ((A = B /\ cC_ A) -> cC_ B)).
Variable cD_substitution_1_3 : (forall A B : Universe, ((A = B /\ cD_ A) -> cD_ B)).
Variable cowlNothing_substitution_1_4 : (forall A B : Universe, ((A = B /\ cowlNothing_ A) -> cowlNothing_ B)).
Variable cowlThing_substitution_1_5 : (forall A B : Universe, ((A = B /\ cowlThing_ A) -> cowlThing_ B)).
Variable xsd_integer_substitution_1_6 : (forall A B : Universe, ((A = B /\ xsd_integer_ A) -> xsd_integer_ B)).
Variable xsd_string_substitution_1_7 : (forall A B : Universe, ((A = B /\ xsd_string_ A) -> xsd_string_ B)).
Variable axiom_0_8 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_9 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_10 : cowlThing_ iA_.
Variable axiom_3_11 : (forall X : Universe, ((cB_ X <-> cC_ X) /\ ((cB_ X <-> X = iA_) /\ ((cB_ X <-> ~(cD_ X)) /\ ((cC_ X <-> X = iA_) /\ ((cC_ X <-> ~(cD_ X)) /\ (X = iA_ <-> ~(cD_ X)))))))).

Theorem conjecture_12 : False.
Proof.
  time hprover.
Qed.

End FOFProblem.
