(*
% File     : KRS053+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : owl:disjointWith edges may be within OWL DL
% Version  : Especial.
% English  : If the owl:disjointWith edges in the graph form an undirected 
%            complete subgraph then this may be within OWL DL.
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : consistent_disjointWith-Manifest003 [Bec03]
% Status   : Satisfiable
% Rating   : 0.00 v3.1.0
% Status (intuit.) : Unsolved (Problem negated)
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :    3 (   0 unit)
%            Number of atoms       :   24 (   0 equality)
%            Maximal formula depth :   13 (   7 average)
%            Number of connectives :   33 (  12 ~  ;   0  |;  20  &)
%                                         (   1 <=>;   0 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    9 (   0 propositional; 1-1 arity)
%            Number of functors    :    0 (   0 constant; --- arity)
%            Number of variables   :    3 (   0 singleton;   3 !;   0 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable xsd_string_ : Universe -> Prop.
Variable xsd_integer_ : Universe -> Prop.
Variable cowlThing_ : Universe -> Prop.
Variable cowlNothing_ : Universe -> Prop.
Variable cE_ : Universe -> Prop.
Variable cD_ : Universe -> Prop.
Variable cC_ : Universe -> Prop.
Variable cB_ : Universe -> Prop.
Variable cA_ : Universe -> Prop.


Variable axiom_0_1 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_2 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_3 : (forall X : Universe, (~((cD_ X /\ cC_ X)) /\ (~((cD_ X /\ cE_ X)) /\ (~((cD_ X /\ cA_ X)) /\ (~((cD_ X /\ cB_ X)) /\ (~((cC_ X /\ cE_ X)) /\ (~((cC_ X /\ cA_ X)) /\ (~((cC_ X /\ cB_ X)) /\ (~((cE_ X /\ cA_ X)) /\ (~((cE_ X /\ cB_ X)) /\ ~((cA_ X /\ cB_ X)))))))))))).

Theorem conjecture_4 : False.
Proof.
  time hprover.
Qed.

End FOFProblem.
