(*
% File     : KRS050+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : DL Test: t8.1
% Version  : Especial.
% English  : 
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : consistent_description-logic-Manifest634 [Bec03]
% Status   : Satisfiable
% Rating   : 0.00 v3.1.0
% Status (intuit.) : Unsolved (Problem negated)
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :   11 (   1 unit)
%            Number of atoms       :   28 (   0 equality)
%            Maximal formula depth :    6 (   4 average)
%            Number of connectives :   20 (   3 ~  ;   0  |;   4  &)
%                                         (   9 <=>;   4 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   15 (   0 propositional; 1-2 arity)
%            Number of functors    :    1 (   1 constant; 0-0 arity)
%            Number of variables   :   19 (   0 singleton;  15 !;   4 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable xsd_string_ : Universe -> Prop.
Variable xsd_integer_ : Universe -> Prop.
Variable rr1_ : Universe -> Universe -> Prop.
Variable rr_ : Universe -> Universe -> Prop.
Variable rinvR_ : Universe -> Universe -> Prop.
Variable ra_Px1_ : Universe -> Universe -> Prop.
Variable cpxcomp_ : Universe -> Prop.
Variable cp_ : Universe -> Prop.
Variable cowlThing_ : Universe -> Prop.
Variable cowlNothing_ : Universe -> Prop.
Variable ca_Vx5_ : Universe -> Prop.
Variable ca_Vx4_ : Universe -> Prop.
Variable ca_Vx3_ : Universe -> Prop.
Variable ca_Vx2_ : Universe -> Prop.
Variable cSatisfiable_ : Universe -> Prop.

Variable i2003_11_14_17_16_39209_ : Universe.

Variable axiom_0_1 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_2 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_3 : (forall X : Universe, (cSatisfiable_ X <-> ((exists Y : Universe, (rr_ X Y /\ ca_Vx4_ Y)) /\ (exists Y : Universe, (rr_ X Y /\ ca_Vx5_ Y))))).
Variable axiom_3_4 : (forall X : Universe, (cp_ X <-> ~((exists Y : Universe, ra_Px1_ X Y)))).
Variable axiom_4_5 : (forall X : Universe, (cpxcomp_ X <-> (exists Y0 : Universe, ra_Px1_ X Y0))).
Variable axiom_5_6 : (forall X : Universe, (ca_Vx2_ X <-> (forall Y : Universe, (rr1_ X Y -> cp_ Y)))).
Variable axiom_6_7 : (forall X : Universe, (ca_Vx3_ X <-> (forall Y : Universe, (rr1_ X Y -> cpxcomp_ Y)))).
Variable axiom_7_8 : (forall X : Universe, (ca_Vx4_ X <-> (forall Y : Universe, (rinvR_ X Y -> ca_Vx2_ Y)))).
Variable axiom_8_9 : (forall X : Universe, (ca_Vx5_ X <-> (forall Y : Universe, (rinvR_ X Y -> ca_Vx3_ Y)))).
Variable axiom_9_10 : (forall X Y : Universe, (rinvR_ X Y <-> rr_ Y X)).
Variable axiom_10_11 : cSatisfiable_ i2003_11_14_17_16_39209_.

Theorem conjecture_12 : False.
Proof.
  time hprover.
Qed.

End FOFProblem.
