(*
% File     : KRS049+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : DL Test: t7f.1
% Version  : Especial.
% English  : 
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : consistent_description-logic-Manifest631 [Bec03]
% Status   : Satisfiable
% Rating   : 0.33 v3.1.0
% Status (intuit.) : Unsolved (Problem negated)
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :   45 (   1 unit)
%            Number of atoms       :  125 (  28 equality)
%            Maximal formula depth :    6 (   5 average)
%            Number of connectives :   85 (   5 ~  ;   0  |;  35  &)
%                                         (  14 <=>;  31 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   21 (   0 propositional; 1-2 arity)
%            Number of functors    :    1 (   1 constant; 0-0 arity)
%            Number of variables   :  101 (   0 singleton;  93 !;   8 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable xsd_string_ : Universe -> Prop.
Variable xsd_integer_ : Universe -> Prop.
Variable rr_ : Universe -> Universe -> Prop.
Variable rinvR_ : Universe -> Universe -> Prop.
Variable rinvF_ : Universe -> Universe -> Prop.
Variable rf_ : Universe -> Universe -> Prop.
Variable ra_Px3_ : Universe -> Universe -> Prop.
Variable ra_Px2_ : Universe -> Universe -> Prop.
Variable ra_Px1_ : Universe -> Universe -> Prop.
Variable cp1xcomp_ : Universe -> Prop.
Variable cp1_ : Universe -> Prop.
Variable cowlThing_ : Universe -> Prop.
Variable cowlNothing_ : Universe -> Prop.
Variable ca_Vx5_ : Universe -> Prop.
Variable ca_Cx3xcomp_ : Universe -> Prop.
Variable ca_Cx3_ : Universe -> Prop.
Variable ca_Cx2xcomp_ : Universe -> Prop.
Variable ca_Cx2_ : Universe -> Prop.
Variable ca_Ax4_ : Universe -> Prop.
Variable cSatisfiable_ : Universe -> Prop.

Variable i2003_11_14_17_16_36130_ : Universe.

Variable cSatisfiable_substitution_1_1 : (forall A B : Universe, ((A = B /\ cSatisfiable_ A) -> cSatisfiable_ B)).
Variable ca_Ax4_substitution_1_2 : (forall A B : Universe, ((A = B /\ ca_Ax4_ A) -> ca_Ax4_ B)).
Variable ca_Cx2_substitution_1_3 : (forall A B : Universe, ((A = B /\ ca_Cx2_ A) -> ca_Cx2_ B)).
Variable ca_Cx2xcomp_substitution_1_4 : (forall A B : Universe, ((A = B /\ ca_Cx2xcomp_ A) -> ca_Cx2xcomp_ B)).
Variable ca_Cx3_substitution_1_5 : (forall A B : Universe, ((A = B /\ ca_Cx3_ A) -> ca_Cx3_ B)).
Variable ca_Cx3xcomp_substitution_1_6 : (forall A B : Universe, ((A = B /\ ca_Cx3xcomp_ A) -> ca_Cx3xcomp_ B)).
Variable ca_Vx5_substitution_1_7 : (forall A B : Universe, ((A = B /\ ca_Vx5_ A) -> ca_Vx5_ B)).
Variable cowlNothing_substitution_1_8 : (forall A B : Universe, ((A = B /\ cowlNothing_ A) -> cowlNothing_ B)).
Variable cowlThing_substitution_1_9 : (forall A B : Universe, ((A = B /\ cowlThing_ A) -> cowlThing_ B)).
Variable cp1_substitution_1_10 : (forall A B : Universe, ((A = B /\ cp1_ A) -> cp1_ B)).
Variable cp1xcomp_substitution_1_11 : (forall A B : Universe, ((A = B /\ cp1xcomp_ A) -> cp1xcomp_ B)).
Variable ra_Px1_substitution_1_12 : (forall A B C : Universe, ((A = B /\ ra_Px1_ A C) -> ra_Px1_ B C)).
Variable ra_Px1_substitution_2_13 : (forall A B C : Universe, ((A = B /\ ra_Px1_ C A) -> ra_Px1_ C B)).
Variable ra_Px2_substitution_1_14 : (forall A B C : Universe, ((A = B /\ ra_Px2_ A C) -> ra_Px2_ B C)).
Variable ra_Px2_substitution_2_15 : (forall A B C : Universe, ((A = B /\ ra_Px2_ C A) -> ra_Px2_ C B)).
Variable ra_Px3_substitution_1_16 : (forall A B C : Universe, ((A = B /\ ra_Px3_ A C) -> ra_Px3_ B C)).
Variable ra_Px3_substitution_2_17 : (forall A B C : Universe, ((A = B /\ ra_Px3_ C A) -> ra_Px3_ C B)).
Variable rf_substitution_1_18 : (forall A B C : Universe, ((A = B /\ rf_ A C) -> rf_ B C)).
Variable rf_substitution_2_19 : (forall A B C : Universe, ((A = B /\ rf_ C A) -> rf_ C B)).
Variable rinvF_substitution_1_20 : (forall A B C : Universe, ((A = B /\ rinvF_ A C) -> rinvF_ B C)).
Variable rinvF_substitution_2_21 : (forall A B C : Universe, ((A = B /\ rinvF_ C A) -> rinvF_ C B)).
Variable rinvR_substitution_1_22 : (forall A B C : Universe, ((A = B /\ rinvR_ A C) -> rinvR_ B C)).
Variable rinvR_substitution_2_23 : (forall A B C : Universe, ((A = B /\ rinvR_ C A) -> rinvR_ C B)).
Variable rr_substitution_1_24 : (forall A B C : Universe, ((A = B /\ rr_ A C) -> rr_ B C)).
Variable rr_substitution_2_25 : (forall A B C : Universe, ((A = B /\ rr_ C A) -> rr_ C B)).
Variable xsd_integer_substitution_1_26 : (forall A B : Universe, ((A = B /\ xsd_integer_ A) -> xsd_integer_ B)).
Variable xsd_string_substitution_1_27 : (forall A B : Universe, ((A = B /\ xsd_string_ A) -> xsd_string_ B)).
Variable axiom_0_28 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_29 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_30 : (forall X : Universe, (cSatisfiable_ X <-> ((exists Y : Universe, (rr_ X Y /\ ca_Vx5_ Y)) /\ cp1_ X))).
Variable axiom_3_31 : (forall X : Universe, (cp1_ X <-> ~((exists Y : Universe, ra_Px1_ X Y)))).
Variable axiom_4_32 : (forall X : Universe, (cp1xcomp_ X <-> (exists Y0 : Universe, ra_Px1_ X Y0))).
Variable axiom_5_33 : (forall X : Universe, (ca_Ax4_ X <-> ((forall Y : Universe, (rinvR_ X Y -> ca_Cx2_ Y)) /\ cp1_ X))).
Variable axiom_6_34 : (forall X : Universe, (ca_Cx2_ X <-> ~((exists Y : Universe, ra_Px2_ X Y)))).
Variable axiom_7_35 : (forall X : Universe, (ca_Cx2xcomp_ X <-> (ca_Cx3_ X /\ cp1_ X))).
Variable axiom_8_36 : (forall X : Universe, (ca_Cx2xcomp_ X <-> (exists Y0 : Universe, ra_Px2_ X Y0))).
Variable axiom_9_37 : (forall X : Universe, (ca_Cx3_ X <-> ~((exists Y : Universe, ra_Px3_ X Y)))).
Variable axiom_10_38 : (forall X : Universe, (ca_Cx3xcomp_ X <-> (exists Y0 : Universe, ra_Px3_ X Y0))).
Variable axiom_11_39 : (forall X : Universe, (ca_Cx3xcomp_ X <-> (forall Y : Universe, (rr_ X Y -> cp1_ Y)))).
Variable axiom_12_40 : (forall X : Universe, (ca_Vx5_ X <-> (exists Y : Universe, (rr_ X Y /\ ca_Ax4_ Y)))).
Variable axiom_13_41 : (forall X Y Z : Universe, ((rf_ X Y /\ rf_ X Z) -> Y = Z)).
Variable axiom_14_42 : (forall X Y : Universe, (rinvF_ X Y <-> rf_ Y X)).
Variable axiom_15_43 : (forall X Y : Universe, (rinvR_ X Y <-> rr_ Y X)).
Variable axiom_16_44 : (forall X Y Z : Universe, ((rr_ X Y /\ rr_ Y Z) -> rr_ X Z)).
Variable axiom_17_45 : cSatisfiable_ i2003_11_14_17_16_36130_.

Theorem conjecture_46 : False.
Proof.
  time hprover.
Qed.

End FOFProblem.
