(*
% File     : KRS047+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : DL Test: t5f.1 Non-finite model example from paper
% Version  : Especial.
% English  : 
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : consistent_description-logic-Manifest625 [Bec03]
% Status   : Satisfiable
% Rating   : 0.00 v3.1.0
% Status (intuit.) : Unsolved (Problem negated)
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :   30 (   1 unit)
%            Number of atoms       :   84 (  19 equality)
%            Maximal formula depth :    7 (   5 average)
%            Number of connectives :   57 (   3 ~  ;   0  |;  26  &)
%                                         (   7 <=>;  21 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   14 (   0 propositional; 1-2 arity)
%            Number of functors    :    1 (   1 constant; 0-0 arity)
%            Number of variables   :   69 (   0 singleton;  64 !;   5 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
%          : The concept should be coherent but has no finite model
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable xsd_string_ : Universe -> Prop.
Variable xsd_integer_ : Universe -> Prop.
Variable rr_ : Universe -> Universe -> Prop.
Variable rinvR_ : Universe -> Universe -> Prop.
Variable rinvF_ : Universe -> Universe -> Prop.
Variable rf_ : Universe -> Universe -> Prop.
Variable ra_Px1_ : Universe -> Universe -> Prop.
Variable cowlThing_ : Universe -> Prop.
Variable cowlNothing_ : Universe -> Prop.
Variable caxcomp_ : Universe -> Prop.
Variable ca_Vx2_ : Universe -> Prop.
Variable ca_ : Universe -> Prop.
Variable cSatisfiable_ : Universe -> Prop.

Variable i2003_11_14_17_16_29157_ : Universe.

Variable cSatisfiable_substitution_1_1 : (forall A B : Universe, ((A = B /\ cSatisfiable_ A) -> cSatisfiable_ B)).
Variable ca_substitution_1_2 : (forall A B : Universe, ((A = B /\ ca_ A) -> ca_ B)).
Variable ca_Vx2_substitution_1_3 : (forall A B : Universe, ((A = B /\ ca_Vx2_ A) -> ca_Vx2_ B)).
Variable caxcomp_substitution_1_4 : (forall A B : Universe, ((A = B /\ caxcomp_ A) -> caxcomp_ B)).
Variable cowlNothing_substitution_1_5 : (forall A B : Universe, ((A = B /\ cowlNothing_ A) -> cowlNothing_ B)).
Variable cowlThing_substitution_1_6 : (forall A B : Universe, ((A = B /\ cowlThing_ A) -> cowlThing_ B)).
Variable ra_Px1_substitution_1_7 : (forall A B C : Universe, ((A = B /\ ra_Px1_ A C) -> ra_Px1_ B C)).
Variable ra_Px1_substitution_2_8 : (forall A B C : Universe, ((A = B /\ ra_Px1_ C A) -> ra_Px1_ C B)).
Variable rf_substitution_1_9 : (forall A B C : Universe, ((A = B /\ rf_ A C) -> rf_ B C)).
Variable rf_substitution_2_10 : (forall A B C : Universe, ((A = B /\ rf_ C A) -> rf_ C B)).
Variable rinvF_substitution_1_11 : (forall A B C : Universe, ((A = B /\ rinvF_ A C) -> rinvF_ B C)).
Variable rinvF_substitution_2_12 : (forall A B C : Universe, ((A = B /\ rinvF_ C A) -> rinvF_ C B)).
Variable rinvR_substitution_1_13 : (forall A B C : Universe, ((A = B /\ rinvR_ A C) -> rinvR_ B C)).
Variable rinvR_substitution_2_14 : (forall A B C : Universe, ((A = B /\ rinvR_ C A) -> rinvR_ C B)).
Variable rr_substitution_1_15 : (forall A B C : Universe, ((A = B /\ rr_ A C) -> rr_ B C)).
Variable rr_substitution_2_16 : (forall A B C : Universe, ((A = B /\ rr_ C A) -> rr_ C B)).
Variable xsd_integer_substitution_1_17 : (forall A B : Universe, ((A = B /\ xsd_integer_ A) -> xsd_integer_ B)).
Variable xsd_string_substitution_1_18 : (forall A B : Universe, ((A = B /\ xsd_string_ A) -> xsd_string_ B)).
Variable axiom_0_19 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_20 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_21 : (forall X : Universe, (cSatisfiable_ X <-> ((exists Y : Universe, (rinvF_ X Y /\ ca_ Y)) /\ (caxcomp_ X /\ (exists Y : Universe, (rinvR_ X Y /\ ca_Vx2_ Y)))))).
Variable axiom_3_22 : (forall X : Universe, (ca_ X <-> ~((exists Y : Universe, ra_Px1_ X Y)))).
Variable axiom_4_23 : (forall X : Universe, (caxcomp_ X <-> (exists Y0 : Universe, ra_Px1_ X Y0))).
Variable axiom_5_24 : (forall X : Universe, (ca_Vx2_ X <-> (exists Y : Universe, (rinvF_ X Y /\ ca_ Y)))).
Variable axiom_6_25 : (forall X Y Z : Universe, ((rf_ X Y /\ rf_ X Z) -> Y = Z)).
Variable axiom_7_26 : (forall X Y : Universe, (rinvF_ X Y <-> rf_ Y X)).
Variable axiom_8_27 : (forall X Y : Universe, (rinvR_ X Y <-> rr_ Y X)).
Variable axiom_9_28 : (forall X Y Z : Universe, ((rr_ X Y /\ rr_ Y Z) -> rr_ X Z)).
Variable axiom_10_29 : cSatisfiable_ i2003_11_14_17_16_29157_.
Variable axiom_11_30 : (forall X Y : Universe, (rf_ X Y -> rr_ X Y)).

Theorem conjecture_31 : False.
Proof.
  time hprover.
Qed.

End FOFProblem.
