(*
% File     : KRS037+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : DL Test: t7.1
% Version  : Especial.
% English  : 
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : consistent_description-logic-Manifest028 [Bec03]
% Status   : Satisfiable
% Rating   : 0.00 v3.1.0
% Status (intuit.) : Unsolved (Problem negated)
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :   22 (   1 unit)
%            Number of atoms       :   67 (  15 equality)
%            Maximal formula depth :   14 (   6 average)
%            Number of connectives :   48 (   3 ~  ;   1  |;  21  &)
%                                         (   4 <=>;  19 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   11 (   0 propositional; 1-2 arity)
%            Number of functors    :    1 (   1 constant; 0-0 arity)
%            Number of variables   :   53 (   0 singleton;  51 !;   2 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable xsd_string_ : Universe -> Prop.
Variable xsd_integer_ : Universe -> Prop.
Variable rr_ : Universe -> Universe -> Prop.
Variable rinvR_ : Universe -> Universe -> Prop.
Variable rinvF_ : Universe -> Universe -> Prop.
Variable rf_ : Universe -> Universe -> Prop.
Variable cp1_ : Universe -> Prop.
Variable cowlThing_ : Universe -> Prop.
Variable cowlNothing_ : Universe -> Prop.
Variable cSatisfiable_ : Universe -> Prop.

Variable i2003_11_14_17_15_51999_ : Universe.

Variable cSatisfiable_substitution_1_1 : (forall A B : Universe, ((A = B /\ cSatisfiable_ A) -> cSatisfiable_ B)).
Variable cowlNothing_substitution_1_2 : (forall A B : Universe, ((A = B /\ cowlNothing_ A) -> cowlNothing_ B)).
Variable cowlThing_substitution_1_3 : (forall A B : Universe, ((A = B /\ cowlThing_ A) -> cowlThing_ B)).
Variable cp1_substitution_1_4 : (forall A B : Universe, ((A = B /\ cp1_ A) -> cp1_ B)).
Variable rf_substitution_1_5 : (forall A B C : Universe, ((A = B /\ rf_ A C) -> rf_ B C)).
Variable rf_substitution_2_6 : (forall A B C : Universe, ((A = B /\ rf_ C A) -> rf_ C B)).
Variable rinvF_substitution_1_7 : (forall A B C : Universe, ((A = B /\ rinvF_ A C) -> rinvF_ B C)).
Variable rinvF_substitution_2_8 : (forall A B C : Universe, ((A = B /\ rinvF_ C A) -> rinvF_ C B)).
Variable rinvR_substitution_1_9 : (forall A B C : Universe, ((A = B /\ rinvR_ A C) -> rinvR_ B C)).
Variable rinvR_substitution_2_10 : (forall A B C : Universe, ((A = B /\ rinvR_ C A) -> rinvR_ C B)).
Variable rr_substitution_1_11 : (forall A B C : Universe, ((A = B /\ rr_ A C) -> rr_ B C)).
Variable rr_substitution_2_12 : (forall A B C : Universe, ((A = B /\ rr_ C A) -> rr_ C B)).
Variable xsd_integer_substitution_1_13 : (forall A B : Universe, ((A = B /\ xsd_integer_ A) -> xsd_integer_ B)).
Variable xsd_string_substitution_1_14 : (forall A B : Universe, ((A = B /\ xsd_string_ A) -> xsd_string_ B)).
Variable axiom_0_15 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_16 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_17 : (forall X : Universe, (cSatisfiable_ X <-> ((exists Y : Universe, (rr_ X Y /\ (exists Z : Universe, (rr_ Y Z /\ ((forall W : Universe, (rinvR_ Z W -> (~(cp1_ W) \/ (forall A : Universe, (rr_ W A -> cp1_ A))))) /\ cp1_ Z))))) /\ cp1_ X))).
Variable axiom_3_18 : (forall X : Universe, (cowlThing_ X -> (forall Y0 Y1 : Universe, ((rf_ X Y0 /\ rf_ X Y1) -> Y0 = Y1)))).
Variable axiom_4_19 : (forall X Y : Universe, (rinvF_ X Y <-> rf_ Y X)).
Variable axiom_5_20 : (forall X Y : Universe, (rinvR_ X Y <-> rr_ Y X)).
Variable axiom_6_21 : (forall X Y Z : Universe, ((rr_ X Y /\ rr_ Y Z) -> rr_ X Z)).
Variable axiom_7_22 : cSatisfiable_ i2003_11_14_17_15_51999_.

Theorem conjecture_23 : False.
Proof.
  time hprover.
Qed.

End FOFProblem.
