(*
% File     : KRS031+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : DL Test: t2.1
% Version  : Especial.
% English  : 
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : consistent_description-logic-Manifest016 [Bec03]
% Status   : Satisfiable
% Rating   : 0.00 v3.1.0
% Status (intuit.) : Unsolved (Problem negated)
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :   22 (   1 unit)
%            Number of atoms       :   63 (  15 equality)
%            Maximal formula depth :    7 (   5 average)
%            Number of connectives :   44 (   3 ~  ;   0  |;  19  &)
%                                         (   2 <=>;  20 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   11 (   0 propositional; 1-2 arity)
%            Number of functors    :    1 (   1 constant; 0-0 arity)
%            Number of variables   :   48 (   0 singleton;  46 !;   2 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable xsd_string_ : Universe -> Prop.
Variable xsd_integer_ : Universe -> Prop.
Variable rr_ : Universe -> Universe -> Prop.
Variable rf2_ : Universe -> Universe -> Prop.
Variable rf1_ : Universe -> Universe -> Prop.
Variable cp2_ : Universe -> Prop.
Variable cp1_ : Universe -> Prop.
Variable cowlThing_ : Universe -> Prop.
Variable cowlNothing_ : Universe -> Prop.
Variable cSatisfiable_ : Universe -> Prop.

Variable i2003_11_14_17_15_2938_ : Universe.

Variable cSatisfiable_substitution_1_1 : (forall A B : Universe, ((A = B /\ cSatisfiable_ A) -> cSatisfiable_ B)).
Variable cowlNothing_substitution_1_2 : (forall A B : Universe, ((A = B /\ cowlNothing_ A) -> cowlNothing_ B)).
Variable cowlThing_substitution_1_3 : (forall A B : Universe, ((A = B /\ cowlThing_ A) -> cowlThing_ B)).
Variable cp1_substitution_1_4 : (forall A B : Universe, ((A = B /\ cp1_ A) -> cp1_ B)).
Variable cp2_substitution_1_5 : (forall A B : Universe, ((A = B /\ cp2_ A) -> cp2_ B)).
Variable rf1_substitution_1_6 : (forall A B C : Universe, ((A = B /\ rf1_ A C) -> rf1_ B C)).
Variable rf1_substitution_2_7 : (forall A B C : Universe, ((A = B /\ rf1_ C A) -> rf1_ C B)).
Variable rf2_substitution_1_8 : (forall A B C : Universe, ((A = B /\ rf2_ A C) -> rf2_ B C)).
Variable rf2_substitution_2_9 : (forall A B C : Universe, ((A = B /\ rf2_ C A) -> rf2_ C B)).
Variable rr_substitution_1_10 : (forall A B C : Universe, ((A = B /\ rr_ A C) -> rr_ B C)).
Variable rr_substitution_2_11 : (forall A B C : Universe, ((A = B /\ rr_ C A) -> rr_ C B)).
Variable xsd_integer_substitution_1_12 : (forall A B : Universe, ((A = B /\ xsd_integer_ A) -> xsd_integer_ B)).
Variable xsd_string_substitution_1_13 : (forall A B : Universe, ((A = B /\ xsd_string_ A) -> xsd_string_ B)).
Variable axiom_0_14 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_15 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_16 : (forall X : Universe, (cSatisfiable_ X <-> ((exists Y : Universe, (rf1_ X Y /\ cp1_ Y)) /\ (exists Y : Universe, (rf2_ X Y /\ cp2_ Y))))).
Variable axiom_3_17 : (forall X : Universe, (cp1_ X -> ~(cp2_ X))).
Variable axiom_4_18 : (forall X : Universe, (cowlThing_ X -> (forall Y0 Y1 : Universe, ((rf2_ X Y0 /\ rf2_ X Y1) -> Y0 = Y1)))).
Variable axiom_5_19 : (forall X : Universe, (cowlThing_ X -> (forall Y0 Y1 : Universe, ((rf1_ X Y0 /\ rf1_ X Y1) -> Y0 = Y1)))).
Variable axiom_6_20 : cSatisfiable_ i2003_11_14_17_15_2938_.
Variable axiom_7_21 : (forall X Y : Universe, (rr_ X Y -> rf1_ X Y)).
Variable axiom_8_22 : (forall X Y : Universe, (rr_ X Y -> rf2_ X Y)).

Theorem conjecture_23 : False.
Proof.
  time hprover.
Qed.

End FOFProblem.
