(*
% File     : KRS024+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : An OWL Lite version of I5.3-007
% Version  : Especial.
% English  : 
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : consistent_I5.3-Manifest008 [Bec03]
% Status   : Satisfiable
% Rating   : 0.00 v3.1.0
% Status (intuit.) : Unsolved (Problem negated)
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :    5 (   3 unit)
%            Number of atoms       :    7 (   0 equality)
%            Maximal formula depth :    4 (   2 average)
%            Number of connectives :    4 (   2 ~  ;   0  |;   1  &)
%                                         (   1 <=>;   0 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    5 (   0 propositional; 1-2 arity)
%            Number of functors    :    2 (   2 constant; 0-0 arity)
%            Number of variables   :    2 (   0 singleton;   2 !;   0 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable xsd_string_ : Universe -> Prop.
Variable xsd_integer_ : Universe -> Prop.
Variable rdp_ : Universe -> Universe -> Prop.
Variable cowlThing_ : Universe -> Prop.
Variable cowlNothing_ : Universe -> Prop.

Variable xsd_string_0_ : Universe.
Variable i2003_11_14_17_14_46558_ : Universe.

Variable axiom_0_1 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_2 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_3 : cowlThing_ i2003_11_14_17_14_46558_.
Variable axiom_3_4 : xsd_string_ xsd_string_0_.
Variable axiom_4_5 : rdp_ i2003_11_14_17_14_46558_ xsd_string_0_.

Theorem conjecture_6 : False.
Proof.
  time hprover.
Qed.

End FOFProblem.
