(*
% File     : HAL001+2 : ILTP v1.1.2
% Domain   : Homological Algebra
% Problem  : Short Five Lemma, Part 1
% Version  : [TPTP] axioms : Augmented.
% English  :
% Refs     : [Wei94] Weibel (1994), An Introduction to Homological Algebra
% Source   : [TPTP]
% Names    :
% Status   : Theorem
% Rating   : 0.82 v3.1.0, 1.00 v2.7.0, 0.83 v2.6.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :   33 (  18 unit)
%            Number of atoms       :   94 (  20 equality)
%            Maximal formula depth :   16 (   5 average)
%            Number of connectives :   61 (   0 ~  ;   0  |;  34  &)
%                                         (   2 <=>;  25 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    7 (   0 propositional; 1-4 arity)
%            Number of functors    :   17 (  14 constant; 0-3 arity)
%            Number of variables   :   77 (   0 singleton;  73 !;   4 ?)
%            Maximal term depth    :    3 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable surjection_ : Universe -> Prop.
Variable morphism_ : Universe -> Universe -> Universe -> Prop.
Variable injection_ : Universe -> Prop.
Variable exact_ : Universe -> Universe -> Prop.
Variable element_ : Universe -> Universe -> Prop.
Variable commute_ : Universe -> Universe -> Universe -> Universe -> Prop.

Variable zero_ : Universe -> Universe.
Variable subtract_ : Universe -> Universe -> Universe -> Universe.
Variable r_ : Universe.
Variable h_ : Universe.
Variable gammma_ : Universe.
Variable gamma_ : Universe.
Variable g_ : Universe.
Variable f_ : Universe.
Variable e_ : Universe.
Variable delta_ : Universe.
Variable d_ : Universe.
Variable c_ : Universe.
Variable beta_ : Universe.
Variable b_ : Universe.
Variable apply_ : Universe -> Universe -> Universe.
Variable alpha_ : Universe.
Variable a_ : Universe.

Variable morphism_1 : (forall Morphism Dom Cod : Universe, (morphism_ Morphism Dom Cod -> ((forall El : Universe, (element_ El Dom -> element_ (apply_ Morphism El) Cod)) /\ (apply_ Morphism (zero_ Dom)) = (zero_ Cod)))).
Variable injection_properties_2 : (forall Morphism Dom Cod : Universe, ((injection_ Morphism /\ morphism_ Morphism Dom Cod) -> (forall El1 El2 : Universe, ((element_ El1 Dom /\ (element_ El2 Dom /\ (apply_ Morphism El1) = (apply_ Morphism El2))) -> El1 = El2)))).
Variable properties_for_injection_3 : (forall Morphism Dom Cod : Universe, ((morphism_ Morphism Dom Cod /\ (forall El1 El2 : Universe, ((element_ El1 Dom /\ (element_ El2 Dom /\ (apply_ Morphism El1) = (apply_ Morphism El2))) -> El1 = El2))) -> injection_ Morphism)).
Variable surjection_properties_4 : (forall Morphism Dom Cod : Universe, ((surjection_ Morphism /\ morphism_ Morphism Dom Cod) -> (forall ElCod : Universe, (element_ ElCod Cod -> (exists ElDom : Universe, (element_ ElDom Dom /\ (apply_ Morphism ElDom) = ElCod)))))).
Variable properties_for_surjection_5 : (forall Morphism Dom Cod : Universe, ((morphism_ Morphism Dom Cod /\ (forall ElCod : Universe, (element_ ElCod Cod -> (exists ElDom : Universe, (element_ ElDom Dom /\ (apply_ Morphism ElDom) = ElCod))))) -> surjection_ Morphism)).
Variable exact_properties_6 : (forall Morphism1 Morphism2 Dom CodDom Cod : Universe, ((exact_ Morphism1 Morphism2 /\ (morphism_ Morphism1 Dom CodDom /\ morphism_ Morphism2 CodDom Cod)) -> (forall ElCodDom : Universe, ((element_ ElCodDom CodDom /\ (apply_ Morphism2 ElCodDom) = (zero_ Cod)) <-> (exists ElDom : Universe, (element_ ElDom Dom /\ (apply_ Morphism1 ElDom) = ElCodDom)))))).
Variable properties_for_exact_7 : (forall Morphism1 Morphism2 Dom CodDom Cod : Universe, ((morphism_ Morphism1 Dom CodDom /\ (morphism_ Morphism2 CodDom Cod /\ (forall ElCodDom : Universe, ((element_ ElCodDom CodDom /\ (apply_ Morphism2 ElCodDom) = (zero_ Cod)) <-> (exists ElDom : Universe, (element_ ElDom Dom /\ (apply_ Morphism1 ElDom) = ElCodDom)))))) -> exact_ Morphism1 Morphism2)).
Variable commute_properties_8 : (forall M1 M2 M3 M4 Dom DomCod1 DomCod2 Cod : Universe, ((commute_ M1 M2 M3 M4 /\ (morphism_ M1 Dom DomCod1 /\ (morphism_ M2 DomCod1 Cod /\ (morphism_ M3 Dom DomCod2 /\ morphism_ M4 DomCod2 Cod)))) -> (forall ElDom : Universe, (element_ ElDom Dom -> (apply_ M2 (apply_ M1 ElDom)) = (apply_ M4 (apply_ M3 ElDom)))))).
Variable properties_for_commute_9 : (forall M1 M2 M3 M4 Dom DomCod1 DomCod2 Cod : Universe, ((morphism_ M1 Dom DomCod1 /\ (morphism_ M2 DomCod1 Cod /\ (morphism_ M3 Dom DomCod2 /\ (morphism_ M4 DomCod2 Cod /\ (forall ElDom : Universe, (element_ ElDom Dom -> (apply_ M2 (apply_ M1 ElDom)) = (apply_ M4 (apply_ M3 ElDom)))))))) -> commute_ M1 M2 M3 M4)).
Variable subtract_in_domain_10 : (forall Dom El1 El2 : Universe, ((element_ El1 Dom /\ element_ El2 Dom) -> element_ (subtract_ Dom El1 El2) Dom)).
Variable subtract_to_0_11 : (forall Dom El : Universe, (element_ El Dom -> (subtract_ Dom El El) = (zero_ Dom))).
Variable subtract_cancellation_12 : (forall Dom El1 El2 : Universe, ((element_ El1 Dom /\ element_ El2 Dom) -> (subtract_ Dom El1 (subtract_ Dom El1 El2)) = El2)).
Variable subtract_distribution_13 : (forall Morphism Dom Cod : Universe, (morphism_ Morphism Dom Cod -> (forall El1 El2 : Universe, ((element_ El1 Dom /\ element_ El2 Dom) -> (apply_ Morphism (subtract_ Dom El1 El2)) = (subtract_ Cod (apply_ Morphism El1) (apply_ Morphism El2)))))).
Variable injection_properties_2_14 : (forall Morphism Dom Cod : Universe, ((injection_ Morphism /\ morphism_ Morphism Dom Cod) -> (forall El : Universe, ((element_ El Dom /\ (apply_ Morphism El) = (zero_ Cod)) -> El = (zero_ Dom))))).
Variable properties_for_injection_2_15 : (forall Morphism Dom Cod : Universe, ((morphism_ Morphism Dom Cod /\ (forall El : Universe, ((element_ El Dom /\ (apply_ Morphism El) = (zero_ Cod)) -> El = (zero_ Dom)))) -> injection_ Morphism)).
Variable alpha_morphism_16 : morphism_ alpha_ a_ b_.
Variable beta_morphism_17 : morphism_ beta_ b_ c_.
Variable gamma_morphism_18 : morphism_ gamma_ d_ e_.
Variable delta_morphism_19 : morphism_ delta_ e_ r_.
Variable f_morphism_20 : morphism_ f_ a_ d_.
Variable g_morphism_21 : morphism_ g_ b_ e_.
Variable h_morphism_22 : morphism_ h_ c_ r_.
Variable alpha_injection_23 : injection_ alpha_.
Variable gamma_injection_24 : injection_ gamma_.
Variable beta_surjection_25 : surjection_ beta_.
Variable delta_surjection_26 : surjection_ delta_.
Variable alpha_beta_exact_27 : exact_ alpha_ beta_.
Variable gamma_delta_exact_28 : exact_ gammma_ delta_.
Variable alpha_g_f_gamma_commute_29 : commute_ alpha_ g_ f_ gamma_.
Variable beta_h_g_delta_commute_30 : commute_ beta_ h_ g_ delta_.
Variable f_injection_31 : injection_ f_.
Variable h_injection_32 : injection_ h_.

Theorem g_injection_33 : injection_ g_.
Proof.
  time hprover.
Qed.

End FOFProblem.
