(*
% File     : GRP194+1 : ILTP v1.1.2
% Domain   : Group Theory (Semigroups)
% Problem  : In semigroups, a surjective homomorphism maps the zero
% Version  : [Gol93] axioms.
% English  : If (F,*) and (H,+) are two semigroups, phi is a surjective 
%            homomorphism from F to H, and id is a left zero for F, 
%            then phi(id) is a left zero for H.
% Refs     : [Gol93] Goller (1993), Anwendung des Theorembeweisers SETHEO a
% Source   : [Gol93]
% Names    : 
% Status   : Theorem
% Rating   : 0.18 v3.1.0, 0.11 v2.7.0, 0.17 v2.6.0, 0.14 v2.5.0, 0.12 v2.4.0, 0.25 v2.3.0, 0.33 v2.2.1, 0.00 v2.1.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :    8 (   2 unit)
%            Number of atoms       :   21 (   4 equality)
%            Maximal formula depth :    8 (   4 average)
%            Number of connectives :   13 (   0 ~  ;   0  |;   6  &)
%                                         (   1 <=>;   6 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    3 (   0 propositional; 2-2 arity)
%            Number of functors    :    5 (   3 constant; 0-3 arity)
%            Number of variables   :   15 (   0 singleton;  14 !;   1 ?)
%            Maximal term depth    :    3 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable left_zero_ : Universe -> Universe -> Prop.
Variable group_member_ : Universe -> Universe -> Prop.

Variable phi_ : Universe -> Universe.
Variable multiply_ : Universe -> Universe -> Universe -> Universe.
Variable h_ : Universe.
Variable f_left_zero_ : Universe.
Variable f_ : Universe.

Variable total_function_1 : (forall G X Y : Universe, ((group_member_ X G /\ group_member_ Y G) -> group_member_ (multiply_ G X Y) G)).
Variable associativity_2 : (forall G X Y Z : Universe, ((group_member_ X G /\ (group_member_ Y G /\ group_member_ Z G)) -> (multiply_ G (multiply_ G X Y) Z) = (multiply_ G X (multiply_ G Y Z)))).
Variable homomorphism1_3 : (forall X : Universe, (group_member_ X f_ -> group_member_ (phi_ X) h_)).
Variable homomorphism2_4 : (forall X Y : Universe, ((group_member_ X f_ /\ group_member_ Y f_) -> (multiply_ h_ (phi_ X) (phi_ Y)) = (phi_ (multiply_ f_ X Y)))).
Variable surjective_5 : (forall X : Universe, (group_member_ X h_ -> (exists Y : Universe, (group_member_ Y f_ /\ (phi_ Y) = X)))).
Variable left_zero_6 : (forall G X : Universe, (left_zero_ G X <-> (group_member_ X G /\ (forall Y : Universe, (group_member_ Y G -> (multiply_ G X Y) = X))))).
Variable left_zero_for_f_7 : left_zero_ f_ f_left_zero_.

Theorem prove_left_zero_h_8 : left_zero_ h_ (phi_ f_left_zero_).
Proof.
  time hprover.
Qed.

End FOFProblem.
