(*
% File     : GRP001+6 : ILTP v1.1.2
% Domain   : Group Theory
% Problem  : X^2 = identity => commutativity
% Version  : Especial.
% English  : If the square of every element is the identity, the system 
%            is commutative.
% Refs     : [Shu04] Shults (2004), Email to G. Sutcliffe
% Source   : [Shu04]
% Names    : 
% Status   : Theorem
% Rating   : 0.33 v3.1.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :    1 (   0 unit)
%            Number of atoms       :   16 (   0 equality)
%            Maximal formula depth :   15 (  15 average)
%            Number of connectives :   15 (   0 ~  ;   0  |;  10  &)
%                                         (   0 <=>;   5 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    1 (   0 propositional; 3-3 arity)
%            Number of functors    :    1 (   0 constant; 1-1 arity)
%            Number of variables   :   24 (   0 singleton;  23 !;   1 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable product_ : Universe -> Universe -> Universe -> Prop.

Variable inverse_ : Universe -> Universe.


Theorem commutativity_1 : (forall E : Universe, (((forall X Y : Universe, (exists Z : Universe, product_ X Y Z)) /\ ((forall X Y Z U V W : Universe, ((product_ X Y U /\ (product_ Y Z V /\ product_ U Z W)) -> product_ X V W)) /\ ((forall X Y Z U V W : Universe, ((product_ X Y U /\ (product_ Y Z V /\ product_ X V W)) -> product_ U Z W)) /\ ((forall X : Universe, product_ X E X) /\ ((forall X : Universe, product_ E X X) /\ ((forall X : Universe, product_ X (inverse_ X) E) /\ (forall X : Universe, product_ (inverse_ X) X E))))))) -> ((forall X : Universe, product_ X X E) -> (forall U V W : Universe, (product_ U V W -> product_ V U W))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
