(*
% File     : GRA010+2 : ILTP v1.1.2
% Domain   : Graph Theory
% Problem  : Maximal shortest path length in terms of triangles
% Version  : Augmented > Especial.
% English  : In a complete graph, if there is a shortest path P from V1 to 
%            V2 with edges E1 and E2, E1 sequential to E2 means there is an 
%            edge E3 such that E1, E2, and E3 form a triangle, then the
%            number of sequential pairs in P is the number of triangles 
%            in P.
% Refs     : 
% Source   : [TPTP]
% Names    : 
% Status   : Theorem
% Rating   : 0.55 v3.1.0
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.75 v1.1.0
% Syntax   : Number of formulae    :   18 (   1 unit)
%            Number of atoms       :   99 (  25 equality)
%            Maximal formula depth :   13 (   9 average)
%            Number of connectives :   87 (   6 ~  ;   3  |;  50  &)
%                                         (   3 <=>;  20 =>;   2 <=)
%                                         (   3 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   12 (   1 propositional; 0-3 arity)
%            Number of functors    :   12 (   6 constant; 0-2 arity)
%            Number of variables   :   76 (   0 singleton;  64 !;  12 ?)
%            Maximal term depth    :    3 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable vertex_ : Universe -> Prop.
Variable triangle_ : Universe -> Universe -> Universe -> Prop.
Variable shortest_path_ : Universe -> Universe -> Universe -> Prop.
Variable sequential_ : Universe -> Universe -> Prop.
Variable precedes_ : Universe -> Universe -> Universe -> Prop.
Variable path_ : Universe -> Universe -> Universe -> Prop.
Variable on_path_ : Universe -> Universe -> Prop.
Variable less_or_equal_ : Universe -> Universe -> Prop.
Variable in_path_ : Universe -> Universe -> Prop.
Variable edge_ : Universe -> Prop.
Variable complete_ : Prop.

Variable triangles_ : Universe.
Variable tail_of_ : Universe -> Universe.
Variable sequential_pairs_ : Universe.
Variable path_cons_ : Universe -> Universe -> Universe.
Variable number_of_in_ : Universe -> Universe -> Universe.
Variable n1_ : Universe.
Variable minus_ : Universe -> Universe -> Universe.
Variable length_of_ : Universe -> Universe.
Variable head_of_ : Universe -> Universe.
Variable graph_ : Universe.
Variable empty_ : Universe.
Variable edges_ : Universe.

Variable no_loops_1 : (forall E : Universe, (edge_ E -> (head_of_ E) <> (tail_of_ E))).
Variable complete_properties_2 : (complete_ -> (forall V1 V2 : Universe, ((vertex_ V1 /\ (vertex_ V2 /\ V1 <> V2)) -> (exists E : Universe, (edge_ E /\ (((V1 = (head_of_ E) /\ V2 = (tail_of_ E)) \/ (V2 = (head_of_ E) /\ V1 = (tail_of_ E))) /\ ~((V1 = (head_of_ E) /\ V2 = (tail_of_ E)) /\ (V2 = (head_of_ E) /\ V1 = (tail_of_ E))))))))).
Variable path_defn_3 : (forall V1 V2 P : Universe, ((vertex_ V1 /\ (vertex_ V2 /\ (exists E : Universe, (edge_ E /\ (V1 = (tail_of_ E) /\ ((V2 = (head_of_ E) /\ P = (path_cons_ E empty_)) \/ (exists TP : Universe, (path_ (head_of_ E) V2 TP /\ P = (path_cons_ E TP))))))))) -> path_ V1 V2 P)).
Variable path_properties_4 : (forall V1 V2 P : Universe, (path_ V1 V2 P -> (vertex_ V1 /\ (vertex_ V2 /\ (exists E : Universe, (edge_ E /\ (V1 = (tail_of_ E) /\ (((V2 = (head_of_ E) /\ P = (path_cons_ E empty_)) \/ (exists TP : Universe, (path_ (head_of_ E) V2 TP /\ P = (path_cons_ E TP)))) /\ ~((V2 = (head_of_ E) /\ P = (path_cons_ E empty_)) /\ (exists TP : Universe, (path_ (head_of_ E) V2 TP /\ P = (path_cons_ E TP)))))))))))).
Variable on_path_properties_5 : (forall V1 V2 P E : Universe, ((path_ V1 V2 P /\ on_path_ E P) -> (edge_ E /\ (in_path_ (head_of_ E) P /\ in_path_ (tail_of_ E) P)))).
Variable in_path_properties_6 : (forall V1 V2 P V : Universe, ((path_ V1 V2 P /\ in_path_ V P) -> (vertex_ V /\ (exists E : Universe, (on_path_ E P /\ (V = (head_of_ E) \/ V = (tail_of_ E))))))).
Variable sequential_defn_7 : (forall E1 E2 : Universe, (sequential_ E1 E2 <-> (edge_ E1 /\ (edge_ E2 /\ (E1 <> E2 /\ (head_of_ E1) = (tail_of_ E2)))))).
Variable precedes_defn_8 : (forall P V1 V2 : Universe, (path_ V1 V2 P -> (forall E1 E2 : Universe, ((on_path_ E1 P /\ (on_path_ E2 P /\ (sequential_ E1 E2 \/ (exists E3 : Universe, (sequential_ E1 E3 /\ precedes_ E3 E2 P))))) -> precedes_ E1 E2 P)))).
Variable precedes_properties_9 : (forall P V1 V2 : Universe, (path_ V1 V2 P -> (forall E1 E2 : Universe, (precedes_ E1 E2 P -> (on_path_ E1 P /\ (on_path_ E2 P /\ ((sequential_ E1 E2 \/ (exists E3 : Universe, (sequential_ E1 E3 /\ precedes_ E3 E2 P))) /\ ~(sequential_ E1 E2 /\ (exists E3 : Universe, (sequential_ E1 E3 /\ precedes_ E3 E2 P)))))))))).
Variable shortest_path_defn_10 : (forall V1 V2 SP : Universe, (shortest_path_ V1 V2 SP <-> (path_ V1 V2 SP /\ (V1 <> V2 /\ (forall P : Universe, (path_ V1 V2 P -> less_or_equal_ (length_of_ SP) (length_of_ P))))))).
Variable shortest_path_properties_11 : (forall V1 V2 E1 E2 P : Universe, ((shortest_path_ V1 V2 P /\ precedes_ E1 E2 P) -> (~((exists E3 : Universe, ((tail_of_ E3) = (tail_of_ E1) /\ (head_of_ E3) = (head_of_ E2)))) /\ ~(precedes_ E2 E1 P)))).
Variable triangle_defn_12 : (forall E1 E2 E3 : Universe, (triangle_ E1 E2 E3 <-> (edge_ E1 /\ (edge_ E2 /\ (edge_ E3 /\ (sequential_ E1 E2 /\ (sequential_ E2 E3 /\ sequential_ E3 E1))))))).
Variable length_defn_13 : (forall V1 V2 P : Universe, (path_ V1 V2 P -> (length_of_ P) = (number_of_in_ edges_ P))).
Variable path_length_sequential_pairs_14 : (forall V1 V2 P : Universe, (path_ V1 V2 P -> (number_of_in_ sequential_pairs_ P) = (minus_ (length_of_ P) n1_))).
Variable sequential_pairs_and_triangles_15 : (forall P V1 V2 : Universe, ((path_ V1 V2 P /\ (forall E1 E2 : Universe, ((on_path_ E1 P /\ (on_path_ E2 P /\ sequential_ E1 E2)) -> (exists E3 : Universe, triangle_ E1 E2 E3)))) -> (number_of_in_ sequential_pairs_ P) = (number_of_in_ triangles_ P))).
Variable graph_has_them_all_16 : (forall Things InThese : Universe, less_or_equal_ (number_of_in_ Things InThese) (number_of_in_ Things graph_)).
Variable sequential_is_triangle_17 : (complete_ -> (forall V1 V2 E1 E2 P : Universe, ((shortest_path_ V1 V2 P /\ (precedes_ E1 E2 P /\ sequential_ E1 E2)) -> (exists E3 : Universe, triangle_ E1 E2 E3)))).

Theorem sequential_pairs_and_triangles_18 : (complete_ -> (forall P V1 V2 : Universe, ((path_ V1 V2 P /\ (forall E1 E2 : Universe, ((on_path_ E1 P /\ (on_path_ E2 P /\ sequential_ E1 E2)) -> (exists E3 : Universe, triangle_ E1 E2 E3)))) -> (number_of_in_ sequential_pairs_ P) = (number_of_in_ triangles_ P)))).
Proof.
  time hprover.
Qed.

End FOFProblem.
