(*
% File     : GPJ001+2 : ILTP v1.1.2
% Domain   : Non-Clausal Group Theory
% Problem  : Example 4.3 (commutativity)
% Version  : [T96] : Especial.
% English  : If x*x=e for all x in group G, where * is a binary operator and
%            e is the identity in G, then G is commutative
% Refs     : [T96] T. Tammet. A resolution theorem prover for intuitionistic 
%                  logic. 13th CADE, LNAI 1104, pp. 2-16, Springer, 1996. 
%          : [CL73] C.-L. Chang & R. C.-T. Lee. Symbolic Logic and Mechanical 
%                   Theorem Proving. New York, Academic Press, 1973.
% Source   : [T95]
% Names    :
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.75 v1.1.0
% Comments : reduced axioms (conditions) and different order
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable product_ : Universe -> Universe -> Universe -> Prop.

Variable identity_ : Universe.
Variable c_ : Universe.
Variable b_ : Universe.
Variable a_ : Universe.

Variable ax5_1 : (forall X : Universe, product_ identity_ X X).
Variable ax4_2 : (forall X : Universe, product_ X identity_ X).
Variable ax8_3 : (forall X : Universe, product_ X X identity_).
Variable ax9_4 : product_ a_ b_ c_.
Variable ax3_5 : (forall X Y U Z V W : Universe, ((product_ X Y U /\ (product_ Y Z V /\ product_ X V W)) -> product_ U Z W)).
Variable ax2_6 : (forall X Y U Z V W : Universe, ((product_ X Y U /\ (product_ Y Z V /\ product_ U Z W)) -> product_ X V W)).

Theorem con_7 : product_ b_ a_ c_.
Proof.
  time hprover.
Qed.

End FOFProblem.
