(*
% File     : GEO111+1 : ILTP v1.1.2
% Domain   : Geometry (Oriented curves)
% Problem  : Basic property of orderings on linear structures 1
% Version  : [EHK99] axioms.
% English  : If Q is between P and R wrt. c, then P, Q and R are incident 
%            with c and are pairwise distinct
% Refs     : [KE99]  Kulik & Eschenbach (1999), A Geometry of Oriented Curv
%          : [EHK99] Eschenbach et al. (1999), Representing Simple Trajecto
% Source   : [KE99]
% Names    : Theorem 3.8 (1) [KE99]
%          : T4 [EHK99]
% Status   : Theorem
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Rating (intuit.) : 1.00 v1.1
% Syntax   : Number of formulae    :   18 (   1 unit)
%            Number of atoms       :   80 (  14 equality)
%            Maximal formula depth :   12 (   8 average)
%            Number of connectives :   70 (   8 ~  ;   9  |;  30  &)
%                                         (  10 <=>;  13 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    9 (   0 propositional; 1-4 arity)
%            Number of functors    :    1 (   0 constant; 2-2 arity)
%            Number of variables   :   62 (   0 singleton;  52 !;  10 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable part_of_ : Universe -> Universe -> Prop.
Variable open_ : Universe -> Prop.
Variable meet_ : Universe -> Universe -> Universe -> Prop.
Variable inner_point_ : Universe -> Universe -> Prop.
Variable incident_c_ : Universe -> Universe -> Prop.
Variable end_point_ : Universe -> Universe -> Prop.
Variable closed_ : Universe -> Prop.
Variable between_c_ : Universe -> Universe -> Universe -> Universe -> Prop.

Variable sum_ : Universe -> Universe -> Universe.

Variable part_of_defn_1 : (forall C C1 : Universe, (part_of_ C1 C <-> (forall P : Universe, (incident_c_ P C1 -> incident_c_ P C)))).
Variable sum_defn_2 : (forall C C1 C2 : Universe, (C = (sum_ C1 C2) <-> (forall Q : Universe, (incident_c_ Q C <-> (incident_c_ Q C1 \/ incident_c_ Q C2))))).
Variable end_point_defn_3 : (forall P C : Universe, (end_point_ P C <-> (incident_c_ P C /\ (forall C1 C2 : Universe, ((part_of_ C1 C /\ (part_of_ C2 C /\ (incident_c_ P C1 /\ incident_c_ P C2))) -> (part_of_ C1 C2 \/ part_of_ C2 C1)))))).
Variable inner_point_defn_4 : (forall P C : Universe, (inner_point_ P C <-> (incident_c_ P C /\ ~(end_point_ P C)))).
Variable meet_defn_5 : (forall P C C1 : Universe, (meet_ P C C1 <-> (incident_c_ P C /\ (incident_c_ P C1 /\ (forall Q : Universe, ((incident_c_ Q C /\ incident_c_ Q C1) -> (end_point_ Q C /\ end_point_ Q C1))))))).
Variable closed_defn_6 : (forall C : Universe, (closed_ C <-> ~((exists P : Universe, end_point_ P C)))).
Variable open_defn_7 : (forall C : Universe, (open_ C <-> (exists P : Universe, end_point_ P C))).
Variable c1_8 : (forall C C1 : Universe, ((part_of_ C1 C /\ C1 <> C) -> open_ C1)).
Variable c2_9 : (forall C C1 C2 C3 : Universe, ((part_of_ C1 C /\ (part_of_ C2 C /\ (part_of_ C3 C /\ (exists P : Universe, (end_point_ P C1 /\ (end_point_ P C2 /\ end_point_ P C3)))))) -> (part_of_ C2 C3 \/ (part_of_ C3 C2 \/ (part_of_ C1 C2 \/ (part_of_ C2 C1 \/ (part_of_ C1 C3 \/ part_of_ C3 C1))))))).
Variable c3_10 : (forall C : Universe, (exists P : Universe, inner_point_ P C)).
Variable c4_11 : (forall C P : Universe, (inner_point_ P C -> (exists C1 C2 : Universe, (meet_ P C1 C2 /\ C = (sum_ C1 C2))))).
Variable c5_12 : (forall C P Q R : Universe, ((end_point_ P C /\ (end_point_ Q C /\ end_point_ R C)) -> (P = Q \/ (P = R \/ Q = R)))).
Variable c6_13 : (forall C P : Universe, (end_point_ P C -> (exists Q : Universe, (end_point_ Q C /\ P <> Q)))).
Variable c7_14 : (forall C C1 C2 P : Universe, ((closed_ C /\ (meet_ P C1 C2 /\ C = (sum_ C1 C2))) -> (forall Q : Universe, (end_point_ Q C1 -> meet_ Q C1 C2)))).
Variable c8_15 : (forall C1 C2 : Universe, ((exists P : Universe, meet_ P C1 C2) -> (exists C : Universe, C = (sum_ C1 C2)))).
Variable c9_16 : (forall C C1 : Universe, ((forall P : Universe, (incident_c_ P C <-> incident_c_ P C1)) -> C = C1)).
Variable between_c_defn_17 : (forall C P Q R : Universe, (between_c_ C P Q R <-> (P <> R /\ (exists Cpp : Universe, (part_of_ Cpp C /\ (end_point_ P Cpp /\ (end_point_ R Cpp /\ inner_point_ Q Cpp))))))).

Theorem theorem_3_8_1_18 : (forall C P Q R : Universe, (between_c_ C P Q R -> (incident_c_ P C /\ (incident_c_ Q C /\ (incident_c_ R C /\ (P <> Q /\ (Q <> R /\ P <> R))))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
