(*
% File     : GEJ091+1 : ILTP v1.1.2
% Domain   : Constructive Geometry
% Problem  : Theorem 6.4.i (Ordered Geometry)
% Version  : [P98] axioms.
% English  : 
% Refs     : [P98] J. von Plato. A Constructive Theory of Ordered Affine
%                  Geometry. Indagationes Mathematicae, vol. 9: 549-562, 
%                  1998.
% Source   : [P98]
% Names    :
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.75 v1.1.0
% Syntax   : 
% Comments :
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable undir_ : Universe -> Universe -> Prop.
Variable point_ : Universe -> Prop.
Variable line_ : Universe -> Prop.
Variable lcon_ : Universe -> Universe -> Prop.
Variable lapt_ : Universe -> Universe -> Prop.
Variable div_ : Universe -> Universe -> Universe -> Prop.
Variable dipt_ : Universe -> Universe -> Prop.
Variable diln_ : Universe -> Universe -> Prop.
Variable con_ : Universe -> Universe -> Prop.
Variable bf_ : Universe -> Universe -> Universe -> Prop.
Variable bet_ : Universe -> Universe -> Universe -> Universe -> Prop.
Variable apt_ : Universe -> Universe -> Prop.

Variable rev_ : Universe -> Universe.
Variable pt_ : Universe -> Universe -> Universe.
Variable par_ : Universe -> Universe -> Universe.
Variable ln_ : Universe -> Universe -> Universe.

Variable ax1_1 : (forall A L : Universe, (apt_ A L <-> (lapt_ A L \/ lapt_ A (rev_ L)))).
Variable ax2_2 : (forall L M : Universe, (con_ L M <-> (undir_ L M /\ undir_ L (rev_ M)))).
Variable ax3_3 : (forall A B L : Universe, (div_ L A B <-> ((lapt_ A L /\ lapt_ B (rev_ L)) \/ (lapt_ A (rev_ L) /\ lapt_ B L)))).
Variable ax4_4 : (forall L A B : Universe, (bf_ L A B <-> (dipt_ A B /\ ((~((lapt_ A L \/ lapt_ A (rev_ L))) /\ ~((lapt_ B L \/ lapt_ B (rev_ L)))) /\ ~(undir_ L (ln_ A B)))))).
Variable ax5_5 : (forall L A B C : Universe, (bet_ L A B C <-> ((bf_ L A B /\ bf_ L B C) \/ (bf_ L C B /\ bf_ L B A)))).
Variable ax1_6 : (forall A : Universe, ~(dipt_ A A)).
Variable ax2_7 : (forall A B C : Universe, (dipt_ A B -> (dipt_ A C \/ dipt_ B C))).
Variable ax3_8 : (forall L : Universe, ~(diln_ L L)).
Variable ax4_9 : (forall L M N : Universe, (diln_ L M -> (diln_ L N \/ diln_ M N))).
Variable ax5_10 : (forall L : Universe, ~(undir_ L L)).
Variable ax6_11 : (forall L M N : Universe, (undir_ L M -> (undir_ L N \/ undir_ M N))).
Variable ax7_12 : (forall L M N : Universe, ((undir_ L M /\ undir_ L (rev_ M)) -> ((undir_ L N /\ undir_ L (rev_ N)) \/ (undir_ M N /\ undir_ M (rev_ N))))).
Variable ax8_13 : (forall L M : Universe, (undir_ L M \/ undir_ L (rev_ M))).
Variable ax9_14 : (forall L M : Universe, ((undir_ L M /\ undir_ L (rev_ M)) -> (lcon_ L M \/ lcon_ L (rev_ M)))).
Variable ax10_15 : (forall A L : Universe, ~((lapt_ A L \/ lapt_ A (rev_ L)))).
Variable ax11_16 : (forall L M : Universe, ~((lcon_ L M \/ lcon_ L (rev_ M)))).
Variable ax1_17 : (forall A B : Universe, ((point_ A /\ (point_ B /\ dipt_ A B)) -> line_ (ln_ A B))).
Variable ax2_18 : (forall L M : Universe, ((line_ L /\ (line_ M /\ (undir_ L M /\ undir_ L (rev_ M)))) -> point_ (pt_ L M))).
Variable ax3_19 : (forall L A : Universe, ((point_ A /\ line_ L) -> line_ (par_ L A))).
Variable ax4_20 : (forall L : Universe, (line_ L -> line_ (rev_ L))).
Variable ax5_21 : (forall A B : Universe, (dipt_ A B -> (~(apt_ A (ln_ A B)) /\ ~(apt_ B (ln_ A B))))).
Variable ax6_22 : (forall L M : Universe, ((undir_ L M /\ undir_ L (rev_ M)) -> (~(apt_ (pt_ L M) L) /\ ~(apt_ (pt_ L M) M)))).
Variable ax7_23 : (forall A L : Universe, ~(apt_ A (par_ L A))).
Variable ax8_24 : (forall L : Universe, ~(diln_ L (rev_ L))).
Variable ax9_25 : (forall A B : Universe, ~(undir_ (ln_ A B) (rev_ (ln_ B A)))).
Variable ax10_26 : (forall A L : Universe, ~(undir_ (par_ L A) L)).
Variable ax1_27 : (forall A B L M : Universe, ((dipt_ A B /\ diln_ L M) -> (lapt_ A L \/ (lapt_ B L \/ (lapt_ A M \/ (lapt_ B M \/ (lapt_ A (rev_ L) \/ (lapt_ B (rev_ L) \/ (lapt_ A (rev_ M) \/ lapt_ B (rev_ M)))))))))).
Variable ax2_28 : (forall A B L : Universe, ((dipt_ A B /\ lapt_ A L) -> (lapt_ B L \/ lcon_ (ln_ A B) L))).
Variable ax1_29 : (forall A B L : Universe, (lapt_ A L -> (dipt_ A B \/ lapt_ B L))).
Variable ax2_30 : (forall A L M : Universe, ((lapt_ A L /\ undir_ L M) -> (diln_ L M \/ lapt_ A (rev_ M)))).
Variable ax3_31 : (forall L M N : Universe, (lcon_ L M -> (undir_ M N \/ lcon_ L N))).

Theorem con_32 : (forall L A B C : Universe, (bet_ L A B C -> bet_ L C B A)).
Proof.
  time hprover.
Qed.

End FOFProblem.
