(*
% File     : GEJ034+1 : ILTP v1.1.2
% Domain   : Constructive Geometry
% Problem  : Theorem 5.4
% Version  : [P95] axioms.
% English  : If the lines X and Y are convergent, and X and Z are convergent,
%          : the intersection point of X and Y, and the intersection point
%          : of X and Z are distinct, then the line connecting these points
%          : is equal to X.
% Refs     : [P95] J. von Plato. The Axioms of Constructive Geometry. Annals
%                  of Pure and Applied Logic 76 (2): 169-200, 1995.
% Source   : [P95]
% Names    :
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.75 v1.1.0
% Comments :
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable dipt_ : Universe -> Universe -> Prop.
Variable diln_ : Universe -> Universe -> Prop.
Variable con_ : Universe -> Universe -> Prop.
Variable apt_ : Universe -> Universe -> Prop.

Variable pt_ : Universe -> Universe -> Universe.
Variable ln_ : Universe -> Universe -> Universe.

Variable a1_1 : (forall X : Universe, ~(dipt_ X X)).
Variable a2_2 : (forall X : Universe, ~(diln_ X X)).
Variable ax3_3 : (forall X : Universe, ~(con_ X X)).
Variable ax4_4 : (forall X Y Z : Universe, (dipt_ X Y -> (dipt_ X Z \/ dipt_ Y Z))).
Variable ax5_5 : (forall X Y Z : Universe, (diln_ X Y -> (diln_ X Z \/ diln_ Y Z))).
Variable ax6_6 : (forall X Y Z : Universe, (con_ X Y -> (con_ X Z \/ con_ Y Z))).
Variable a1_7 : (forall X Y : Universe, (dipt_ X Y -> ~(apt_ X (ln_ X Y)))).
Variable a2_8 : (forall X Y : Universe, (dipt_ X Y -> ~(apt_ Y (ln_ X Y)))).
Variable a3_9 : (forall X Y : Universe, (con_ X Y -> ~(apt_ (pt_ X Y) X))).
Variable a4_10 : (forall X Y : Universe, (con_ X Y -> ~(apt_ (pt_ X Y) Y))).
Variable a1_11 : (forall X Y U V : Universe, ((dipt_ X Y /\ diln_ U V) -> ((apt_ X U \/ apt_ X V) \/ (apt_ Y U \/ apt_ Y V)))).
Variable a1_12 : (forall X Y Z : Universe, (apt_ X Y -> (dipt_ X Z \/ apt_ Z Y))).
Variable a2_13 : (forall X Y Z : Universe, (apt_ X Y -> (diln_ Y Z \/ apt_ X Z))).
Variable a3_14 : (forall X Y Z : Universe, (con_ X Y -> (diln_ Y Z \/ con_ X Z))).

Theorem con_15 : (forall X Y Z : Universe, ((con_ X Y /\ (con_ X Z /\ dipt_ (pt_ X Y) (pt_ X Z))) -> ~(diln_ (ln_ (pt_ X Y) (pt_ X Z)) X))).
Proof.
  time hprover.
Qed.

End FOFProblem.
