(*
% File     : GEJ001+3 : ILTP v1.1.2
% Domain   : Constructive Geometry
% Problem  : Theorem 3.1. Uniqueness of constructed lines
% Version  : [T96] axioms : Especial.
% English  : If two distinct points are incident with a line, then this line
%          : is equivalent with the connecting line of these points.
% Refs     : [P95] J. von Plato. The Axioms of Constructive Geometry. Annals
%                  of Pure and Applied Logic 76 (2): 169-200, 1995.
%          : [T96] T. Tammet. A resolution theorem prover for intuitionistic 
%                  logic. 13th CADE, LNAI 1104, pp. 2-16, Springer, 1996. 
% Source   : [T96]
% Names    :
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.00 v1.1.0
% Comments : Reduced axioms
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable dipt_ : Universe -> Universe -> Prop.
Variable diln_ : Universe -> Universe -> Prop.
Variable con_ : Universe -> Universe -> Prop.
Variable apt_ : Universe -> Universe -> Prop.

Variable pt_ : Universe -> Universe -> Universe.
Variable ln_ : Universe -> Universe -> Universe.

Variable a1_1 : (forall X Y : Universe, (dipt_ X Y -> ~(apt_ X (ln_ X Y)))).
Variable a2_2 : (forall X Y : Universe, (dipt_ X Y -> ~(apt_ Y (ln_ X Y)))).
Variable a3_3 : (forall X Y : Universe, (con_ X Y -> ~(apt_ (pt_ X Y) X))).
Variable a4_4 : (forall X Y : Universe, (con_ X Y -> ~(apt_ (pt_ X Y) Y))).
Variable a1_5 : (forall X Y U V : Universe, ((dipt_ X Y /\ diln_ U V) -> ((apt_ X U \/ apt_ X V) \/ (apt_ Y U \/ apt_ Y V)))).

Theorem con_6 : (forall X Y Z : Universe, ((dipt_ X Y /\ (~(apt_ X Z) /\ ~(apt_ Y Z))) -> ~(diln_ Z (ln_ X Y)))).
Proof.
  time hprover.
Qed.

End FOFProblem.
