(*
% File     : CSR024+1.009 : ILTP v1.1.2
% Domain   : Commonsense Reasoning
% Problem  : Multiple trolleys, size 9
% Version  : [Mue05] axioms : Especial.
% English  : Each agent pushes and pulls, so all trolleys spin together.
% Refs     : [Mue05] Mueller (2005), Email to Geoff Sutcliffe
% Source   : [Mue05]
% Names    : 
% Status   : Theorem 
% Rating   : 0.55 v3.1.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :   58 (  23 unit)
%            Number of atoms       :  316 ( 177 equality)
%            Maximal formula depth :   73 (   7 average)
%            Number of connectives :  409 ( 151 ~  ;  34  |; 192  &)
%                                         (  18 <=>;  14 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   13 (   0 propositional; 2-4 arity)
%            Number of functors    :   34 (  28 constant; 0-2 arity)
%            Number of variables   :  116 (   0 singleton;  99 !;  17 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments :
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable trajectory_ : Universe -> Universe -> Universe -> Universe -> Prop.
Variable terminates_ : Universe -> Universe -> Universe -> Prop.
Variable stoppedIn_ : Universe -> Universe -> Universe -> Prop.
Variable startedIn_ : Universe -> Universe -> Universe -> Prop.
Variable releases_ : Universe -> Universe -> Universe -> Prop.
Variable releasedAt_ : Universe -> Universe -> Prop.
Variable less_or_equal_ : Universe -> Universe -> Prop.
Variable less_ : Universe -> Universe -> Prop.
Variable initiates_ : Universe -> Universe -> Universe -> Prop.
Variable holdsAt_ : Universe -> Universe -> Prop.
Variable happens_ : Universe -> Universe -> Prop.
Variable antitrajectory_ : Universe -> Universe -> Universe -> Universe -> Prop.

Variable trolley9_ : Universe.
Variable trolley8_ : Universe.
Variable trolley7_ : Universe.
Variable trolley6_ : Universe.
Variable trolley5_ : Universe.
Variable trolley4_ : Universe.
Variable trolley3_ : Universe.
Variable trolley2_ : Universe.
Variable trolley1_ : Universe.
Variable spinning_ : Universe -> Universe.
Variable push_ : Universe -> Universe -> Universe.
Variable pull_ : Universe -> Universe -> Universe.
Variable plus_ : Universe -> Universe -> Universe.
Variable n9_ : Universe.
Variable n8_ : Universe.
Variable n7_ : Universe.
Variable n6_ : Universe.
Variable n5_ : Universe.
Variable n4_ : Universe.
Variable n3_ : Universe.
Variable n2_ : Universe.
Variable n1_ : Universe.
Variable n0_ : Universe.
Variable forwards_ : Universe -> Universe.
Variable backwards_ : Universe -> Universe.
Variable agent9_ : Universe.
Variable agent8_ : Universe.
Variable agent7_ : Universe.
Variable agent6_ : Universe.
Variable agent5_ : Universe.
Variable agent4_ : Universe.
Variable agent3_ : Universe.
Variable agent2_ : Universe.
Variable agent1_ : Universe.

Variable stoppedin_defn_1 : (forall Time1 Fluent Time2 : Universe, (stoppedIn_ Time1 Fluent Time2 <-> (exists Event Time : Universe, (happens_ Event Time /\ (less_ Time1 Time /\ (less_ Time Time2 /\ terminates_ Event Fluent Time)))))).
Variable startedin_defn_2 : (forall Time1 Time2 Fluent : Universe, (startedIn_ Time1 Fluent Time2 <-> (exists Event Time : Universe, (happens_ Event Time /\ (less_ Time1 Time /\ (less_ Time Time2 /\ initiates_ Event Fluent Time)))))).
Variable change_holding_3 : (forall Event Time Fluent Fluent2 Offset : Universe, ((happens_ Event Time /\ (initiates_ Event Fluent Time /\ (less_ n0_ Offset /\ (trajectory_ Fluent Time Fluent2 Offset /\ ~(stoppedIn_ Time Fluent (plus_ Time Offset)))))) -> holdsAt_ Fluent2 (plus_ Time Offset))).
Variable antitrajectory_4 : (forall Event Time1 Fluent1 Time2 Fluent2 : Universe, ((happens_ Event Time1 /\ (terminates_ Event Fluent1 Time1 /\ (less_ n0_ Time2 /\ (antitrajectory_ Fluent1 Time1 Fluent2 Time2 /\ ~(startedIn_ Time1 Fluent1 (plus_ Time1 Time2)))))) -> holdsAt_ Fluent2 (plus_ Time1 Time2))).
Variable keep_holding_5 : (forall Fluent Time : Universe, ((holdsAt_ Fluent Time /\ (~(releasedAt_ Fluent (plus_ Time n1_)) /\ ~((exists Event : Universe, (happens_ Event Time /\ terminates_ Event Fluent Time))))) -> holdsAt_ Fluent (plus_ Time n1_))).
Variable keep_not_holding_6 : (forall Fluent Time : Universe, ((~(holdsAt_ Fluent Time) /\ (~(releasedAt_ Fluent (plus_ Time n1_)) /\ ~((exists Event : Universe, (happens_ Event Time /\ initiates_ Event Fluent Time))))) -> ~(holdsAt_ Fluent (plus_ Time n1_)))).
Variable keep_released_7 : (forall Fluent Time : Universe, ((releasedAt_ Fluent Time /\ ~((exists Event : Universe, (happens_ Event Time /\ (initiates_ Event Fluent Time \/ terminates_ Event Fluent Time))))) -> releasedAt_ Fluent (plus_ Time n1_))).
Variable keep_not_released_8 : (forall Fluent Time : Universe, ((~(releasedAt_ Fluent Time) /\ ~((exists Event : Universe, (happens_ Event Time /\ releases_ Event Fluent Time)))) -> ~(releasedAt_ Fluent (plus_ Time n1_)))).
Variable happens_holds_9 : (forall Event Time Fluent : Universe, ((happens_ Event Time /\ initiates_ Event Fluent Time) -> holdsAt_ Fluent (plus_ Time n1_))).
Variable happens_terminates_not_holds_10 : (forall Event Time Fluent : Universe, ((happens_ Event Time /\ terminates_ Event Fluent Time) -> ~(holdsAt_ Fluent (plus_ Time n1_)))).
Variable happens_releases_11 : (forall Event Time Fluent : Universe, ((happens_ Event Time /\ releases_ Event Fluent Time) -> releasedAt_ Fluent (plus_ Time n1_))).
Variable happens_not_released_12 : (forall Event Time Fluent : Universe, ((happens_ Event Time /\ (initiates_ Event Fluent Time \/ terminates_ Event Fluent Time)) -> ~(releasedAt_ Fluent (plus_ Time n1_)))).
Variable initiates_all_defn_13 : (forall Event Fluent Time : Universe, (initiates_ Event Fluent Time <-> (exists Agent Trolley : Universe, ((Event = (push_ Agent Trolley) /\ (Fluent = (forwards_ Trolley) /\ ~(happens_ (pull_ Agent Trolley) Time))) \/ ((Event = (pull_ Agent Trolley) /\ (Fluent = (backwards_ Trolley) /\ ~(happens_ (push_ Agent Trolley) Time))) \/ (Event = (pull_ Agent Trolley) /\ (Fluent = (spinning_ Trolley) /\ happens_ (push_ Agent Trolley) Time))))))).
Variable terminates_all_defn_14 : (forall Event Fluent Time : Universe, (terminates_ Event Fluent Time <-> (exists Agent Trolley : Universe, ((Event = (push_ Agent Trolley) /\ (Fluent = (backwards_ Trolley) /\ ~(happens_ (pull_ Agent Trolley) Time))) \/ ((Event = (pull_ Agent Trolley) /\ (Fluent = (forwards_ Trolley) /\ ~(happens_ (push_ Agent Trolley) Time))) \/ ((Event = (pull_ Agent Trolley) /\ (Fluent = (forwards_ Trolley) /\ happens_ (push_ Agent Trolley) Time)) \/ ((Event = (pull_ Agent Trolley) /\ (Fluent = (backwards_ Trolley) /\ happens_ (push_ Agent Trolley) Time)) \/ ((Event = (push_ Agent Trolley) /\ (Fluent = (spinning_ Trolley) /\ ~(happens_ (pull_ Agent Trolley) Time))) \/ (Event = (pull_ Agent Trolley) /\ (Fluent = (spinning_ Trolley) /\ ~(happens_ (push_ Agent Trolley) Time))))))))))).
Variable releases_all_defn_15 : (forall Event Fluent Time : Universe, ~(releases_ Event Fluent Time)).
Variable push_not_pull_16 : (forall Agent Trolley : Universe, (push_ Agent Trolley) <> (pull_ Agent Trolley)).
Variable push_unique_17 : (forall Agent1 Agent2 Trolley1 Trolley2 : Universe, ((Agent1 <> Agent2 /\ Trolley1 <> Trolley2) -> (push_ Agent1 Trolley1) <> (push_ Agent2 Trolley2))).
Variable pull_unique_18 : (forall Agent1 Agent2 Trolley1 Trolley2 : Universe, ((Agent1 <> Agent2 /\ Trolley1 <> Trolley2) -> (pull_ Agent1 Trolley1) <> (pull_ Agent2 Trolley2))).
Variable forwards_not_backwards_19 : (forall Trolley : Universe, (forwards_ Trolley) <> (backwards_ Trolley)).
Variable forwards_not_spinning_20 : (forall Trolley : Universe, (forwards_ Trolley) <> (spinning_ Trolley)).
Variable spinning_not_backwards_21 : (forall Trolley : Universe, (spinning_ Trolley) <> (backwards_ Trolley)).
Variable plus0_0_22 : (plus_ n0_ n0_) = n0_.
Variable plus0_1_23 : (plus_ n0_ n1_) = n1_.
Variable plus0_2_24 : (plus_ n0_ n2_) = n2_.
Variable plus0_3_25 : (plus_ n0_ n3_) = n3_.
Variable plus1_1_26 : (plus_ n1_ n1_) = n2_.
Variable plus1_2_27 : (plus_ n1_ n2_) = n3_.
Variable plus1_3_28 : (plus_ n1_ n3_) = n4_.
Variable plus2_2_29 : (plus_ n2_ n2_) = n4_.
Variable plus2_3_30 : (plus_ n2_ n3_) = n5_.
Variable plus3_3_31 : (plus_ n3_ n3_) = n6_.
Variable symmetry_of_plus_32 : (forall X Y : Universe, (plus_ X Y) = (plus_ Y X)).
Variable less_or_equal_33 : (forall X Y : Universe, (less_or_equal_ X Y <-> (less_ X Y \/ X = Y))).
Variable less0_34 : ~((exists X : Universe, less_ X n0_)).
Variable less1_35 : (forall X : Universe, (less_ X n1_ <-> less_or_equal_ X n0_)).
Variable less2_36 : (forall X : Universe, (less_ X n2_ <-> less_or_equal_ X n1_)).
Variable less3_37 : (forall X : Universe, (less_ X n3_ <-> less_or_equal_ X n2_)).
Variable less4_38 : (forall X : Universe, (less_ X n4_ <-> less_or_equal_ X n3_)).
Variable less5_39 : (forall X : Universe, (less_ X n5_ <-> less_or_equal_ X n4_)).
Variable less6_40 : (forall X : Universe, (less_ X n6_ <-> less_or_equal_ X n5_)).
Variable less7_41 : (forall X : Universe, (less_ X n7_ <-> less_or_equal_ X n6_)).
Variable less8_42 : (forall X : Universe, (less_ X n8_ <-> less_or_equal_ X n7_)).
Variable less9_43 : (forall X : Universe, (less_ X n9_ <-> less_or_equal_ X n8_)).
Variable less_property_44 : (forall X Y : Universe, (less_ X Y <-> (~(less_ Y X) /\ Y <> X))).
Variable initiates_all_defn_45 : (forall Event Fluent Time : Universe, (initiates_ Event Fluent Time <-> (exists Agent Trolley : Universe, ((Event = (push_ Agent Trolley) /\ (Fluent = (forwards_ Trolley) /\ ~(happens_ (pull_ Agent Trolley) Time))) \/ ((Event = (pull_ Agent Trolley) /\ (Fluent = (backwards_ Trolley) /\ ~(happens_ (push_ Agent Trolley) Time))) \/ (Event = (pull_ Agent Trolley) /\ (Fluent = (spinning_ Trolley) /\ happens_ (push_ Agent Trolley) Time))))))).
Variable terminates_all_defn_46 : (forall Event Fluent Time : Universe, (terminates_ Event Fluent Time <-> (exists Agent Trolley : Universe, ((Event = (push_ Agent Trolley) /\ (Fluent = (backwards_ Trolley) /\ ~(happens_ (pull_ Agent Trolley) Time))) \/ ((Event = (pull_ Agent Trolley) /\ (Fluent = (forwards_ Trolley) /\ ~(happens_ (push_ Agent Trolley) Time))) \/ ((Event = (pull_ Agent Trolley) /\ (Fluent = (forwards_ Trolley) /\ happens_ (push_ Agent Trolley) Time)) \/ ((Event = (pull_ Agent Trolley) /\ (Fluent = (backwards_ Trolley) /\ happens_ (push_ Agent Trolley) Time)) \/ ((Event = (push_ Agent Trolley) /\ (Fluent = (spinning_ Trolley) /\ ~(happens_ (pull_ Agent Trolley) Time))) \/ (Event = (pull_ Agent Trolley) /\ (Fluent = (spinning_ Trolley) /\ ~(happens_ (push_ Agent Trolley) Time))))))))))).
Variable releases_all_defn_47 : (forall Event Fluent Time : Universe, ~(releases_ Event Fluent Time)).
Variable happens_all_defn_48 : (forall Event Time : Universe, (happens_ Event Time <-> ((Event = (pull_ agent1_ trolley1_) /\ Time = n0_) \/ ((Event = (push_ agent1_ trolley1_) /\ Time = n0_) \/ ((Event = (pull_ agent2_ trolley2_) /\ Time = n0_) \/ ((Event = (push_ agent2_ trolley2_) /\ Time = n0_) \/ ((Event = (pull_ agent3_ trolley3_) /\ Time = n0_) \/ ((Event = (push_ agent3_ trolley3_) /\ Time = n0_) \/ ((Event = (pull_ agent4_ trolley4_) /\ Time = n0_) \/ ((Event = (push_ agent4_ trolley4_) /\ Time = n0_) \/ ((Event = (pull_ agent5_ trolley5_) /\ Time = n0_) \/ ((Event = (push_ agent5_ trolley5_) /\ Time = n0_) \/ ((Event = (pull_ agent6_ trolley6_) /\ Time = n0_) \/ ((Event = (push_ agent6_ trolley6_) /\ Time = n0_) \/ ((Event = (pull_ agent7_ trolley7_) /\ Time = n0_) \/ ((Event = (push_ agent7_ trolley7_) /\ Time = n0_) \/ ((Event = (pull_ agent8_ trolley8_) /\ Time = n0_) \/ ((Event = (push_ agent8_ trolley8_) /\ Time = n0_) \/ ((Event = (pull_ agent9_ trolley9_) /\ Time = n0_) \/ (Event = (push_ agent9_ trolley9_) /\ Time = n0_)))))))))))))))))))).
Variable push_not_pull_49 : (forall Agent Trolley : Universe, (push_ Agent Trolley) <> (pull_ Agent Trolley)).
Variable push_unique_50 : (forall Agent1 Agent2 Trolley1 Trolley2 : Universe, ((Agent1 <> Agent2 /\ Trolley1 <> Trolley2) -> (push_ Agent1 Trolley1) <> (push_ Agent2 Trolley2))).
Variable pull_unique_51 : (forall Agent1 Agent2 Trolley1 Trolley2 : Universe, ((Agent1 <> Agent2 /\ Trolley1 <> Trolley2) -> (pull_ Agent1 Trolley1) <> (pull_ Agent2 Trolley2))).
Variable forwards_not_backwards_52 : (forall Trolley : Universe, (forwards_ Trolley) <> (backwards_ Trolley)).
Variable forwards_not_spinning_53 : (forall Trolley : Universe, (forwards_ Trolley) <> (spinning_ Trolley)).
Variable spinning_not_backwards_54 : (forall Trolley : Universe, (spinning_ Trolley) <> (backwards_ Trolley)).
Variable initial_cond_55 : (~(holdsAt_ (forwards_ trolley1_) n0_) /\ (~(holdsAt_ (backwards_ trolley1_) n0_) /\ (~(holdsAt_ (spinning_ trolley1_) n0_) /\ (~(holdsAt_ (forwards_ trolley2_) n0_) /\ (~(holdsAt_ (backwards_ trolley2_) n0_) /\ (~(holdsAt_ (spinning_ trolley2_) n0_) /\ (~(holdsAt_ (forwards_ trolley3_) n0_) /\ (~(holdsAt_ (backwards_ trolley3_) n0_) /\ (~(holdsAt_ (spinning_ trolley3_) n0_) /\ (~(holdsAt_ (forwards_ trolley4_) n0_) /\ (~(holdsAt_ (backwards_ trolley4_) n0_) /\ (~(holdsAt_ (spinning_ trolley4_) n0_) /\ (~(holdsAt_ (forwards_ trolley5_) n0_) /\ (~(holdsAt_ (backwards_ trolley5_) n0_) /\ (~(holdsAt_ (spinning_ trolley5_) n0_) /\ (~(holdsAt_ (forwards_ trolley6_) n0_) /\ (~(holdsAt_ (backwards_ trolley6_) n0_) /\ (~(holdsAt_ (spinning_ trolley6_) n0_) /\ (~(holdsAt_ (forwards_ trolley7_) n0_) /\ (~(holdsAt_ (backwards_ trolley7_) n0_) /\ (~(holdsAt_ (spinning_ trolley7_) n0_) /\ (~(holdsAt_ (forwards_ trolley8_) n0_) /\ (~(holdsAt_ (backwards_ trolley8_) n0_) /\ (~(holdsAt_ (spinning_ trolley8_) n0_) /\ (~(holdsAt_ (forwards_ trolley9_) n0_) /\ (~(holdsAt_ (backwards_ trolley9_) n0_) /\ ~(holdsAt_ (spinning_ trolley9_) n0_))))))))))))))))))))))))))).
Variable not_releasedAt_56 : (forall Fluent Time : Universe, ~(releasedAt_ Fluent Time)).
Variable distinct_agents_and_trolleys_57 : (trolley1_ <> trolley2_ /\ (agent1_ <> agent2_ /\ (trolley1_ <> trolley3_ /\ (agent1_ <> agent3_ /\ (trolley1_ <> trolley4_ /\ (agent1_ <> agent4_ /\ (trolley1_ <> trolley5_ /\ (agent1_ <> agent5_ /\ (trolley1_ <> trolley6_ /\ (agent1_ <> agent6_ /\ (trolley1_ <> trolley7_ /\ (agent1_ <> agent7_ /\ (trolley1_ <> trolley8_ /\ (agent1_ <> agent8_ /\ (trolley1_ <> trolley9_ /\ (agent1_ <> agent9_ /\ (trolley2_ <> trolley3_ /\ (agent2_ <> agent3_ /\ (trolley2_ <> trolley4_ /\ (agent2_ <> agent4_ /\ (trolley2_ <> trolley5_ /\ (agent2_ <> agent5_ /\ (trolley2_ <> trolley6_ /\ (agent2_ <> agent6_ /\ (trolley2_ <> trolley7_ /\ (agent2_ <> agent7_ /\ (trolley2_ <> trolley8_ /\ (agent2_ <> agent8_ /\ (trolley2_ <> trolley9_ /\ (agent2_ <> agent9_ /\ (trolley3_ <> trolley4_ /\ (agent3_ <> agent4_ /\ (trolley3_ <> trolley5_ /\ (agent3_ <> agent5_ /\ (trolley3_ <> trolley6_ /\ (agent3_ <> agent6_ /\ (trolley3_ <> trolley7_ /\ (agent3_ <> agent7_ /\ (trolley3_ <> trolley8_ /\ (agent3_ <> agent8_ /\ (trolley3_ <> trolley9_ /\ (agent3_ <> agent9_ /\ (trolley4_ <> trolley5_ /\ (agent4_ <> agent5_ /\ (trolley4_ <> trolley6_ /\ (agent4_ <> agent6_ /\ (trolley4_ <> trolley7_ /\ (agent4_ <> agent7_ /\ (trolley4_ <> trolley8_ /\ (agent4_ <> agent8_ /\ (trolley4_ <> trolley9_ /\ (agent4_ <> agent9_ /\ (trolley5_ <> trolley6_ /\ (agent5_ <> agent6_ /\ (trolley5_ <> trolley7_ /\ (agent5_ <> agent7_ /\ (trolley5_ <> trolley8_ /\ (agent5_ <> agent8_ /\ (trolley5_ <> trolley9_ /\ (agent5_ <> agent9_ /\ (trolley6_ <> trolley7_ /\ (agent6_ <> agent7_ /\ (trolley6_ <> trolley8_ /\ (agent6_ <> agent8_ /\ (trolley6_ <> trolley9_ /\ (agent6_ <> agent9_ /\ (trolley7_ <> trolley8_ /\ (agent7_ <> agent8_ /\ (trolley7_ <> trolley9_ /\ (agent7_ <> agent9_ /\ (trolley8_ <> trolley9_ /\ agent8_ <> agent9_))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))).

Theorem spinning_3_58 : (holdsAt_ (spinning_ trolley1_) n1_ /\ (holdsAt_ (spinning_ trolley2_) n1_ /\ (holdsAt_ (spinning_ trolley3_) n1_ /\ (holdsAt_ (spinning_ trolley4_) n1_ /\ (holdsAt_ (spinning_ trolley5_) n1_ /\ (holdsAt_ (spinning_ trolley6_) n1_ /\ (holdsAt_ (spinning_ trolley7_) n1_ /\ (holdsAt_ (spinning_ trolley8_) n1_ /\ holdsAt_ (spinning_ trolley9_) n1_)))))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
