(*
% File     : COM003+3 : ILTP v1.1.2
% Domain   : Computing Theory
% Problem  : The halting problem is undecidable
% Version  : [Daf94] axioms.
% English  : 
% Refs     : [Bur87a] Burkholder (1987), The Halting Problem
%          : [Bur87b] Burkholder (1987), A 76th Automated Theorem Proving Pr
%          : [Daf94] Dafa (1994), The Formulation of the Halting Problem Is
% Source   : [Daf94]
% Names    : - [Daf94]
% Status   : Theorem
% Rating   : 0.22 v3.1.0, 0.33 v2.7.0, 0.00 v2.5.0, 0.33 v2.4.0, 0.33 v2.2.1, 0.00 v2.1.0
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.75 v1.0.0
% Syntax   : Number of formulae    :    4 (   0 unit)
%            Number of atoms       :   39 (   0 equality)
%            Maximal formula depth :   10 (   8 average)
%            Number of connectives :   39 (   4 ~  ;   0  |;  22  &)
%                                         (   0 <=>;  13 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    6 (   0 propositional; 1-3 arity)
%            Number of functors    :    2 (   2 constant; 0-0 arity)
%            Number of variables   :   19 (   0 singleton;  15 !;   4 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable program_ : Universe -> Prop.
Variable outputs_ : Universe -> Universe -> Prop.
Variable halts3_ : Universe -> Universe -> Universe -> Prop.
Variable halts2_ : Universe -> Universe -> Prop.
Variable decides_ : Universe -> Universe -> Universe -> Prop.
Variable algorithm_ : Universe -> Prop.

Variable good_ : Universe.
Variable bad_ : Universe.

Variable p1_1 : ((exists X : Universe, (algorithm_ X /\ (forall Y : Universe, (program_ Y -> (forall Z : Universe, decides_ X Y Z))))) -> (exists W : Universe, (program_ W /\ (forall Y : Universe, (program_ Y -> (forall Z : Universe, decides_ W Y Z)))))).
Variable p2_2 : (forall W : Universe, ((program_ W /\ (forall Y : Universe, (program_ Y -> (forall Z : Universe, decides_ W Y Z)))) -> (forall Y Z : Universe, (((program_ Y /\ halts2_ Y Z) -> (halts3_ W Y Z /\ outputs_ W good_)) /\ ((program_ Y /\ ~(halts2_ Y Z)) -> (halts3_ W Y Z /\ outputs_ W bad_)))))).
Variable p3_3 : (forall W : Universe, ((program_ W /\ (forall Y Z : Universe, (((program_ Y /\ halts2_ Y Z) -> (halts3_ W Y Z /\ outputs_ W good_)) /\ ((program_ Y /\ ~(halts2_ Y Z)) -> (halts3_ W Y Z /\ outputs_ W bad_))))) -> (exists V : Universe, (program_ V /\ (forall Y : Universe, (((program_ Y /\ (halts3_ W Y Y /\ outputs_ W good_)) -> ~(halts2_ V Y)) /\ ((program_ Y /\ (halts3_ W Y Y /\ outputs_ W bad_)) -> (halts2_ V Y /\ outputs_ V bad_)))))))).

Theorem prove_this_4 : ~((exists X1 : Universe, (algorithm_ X1 /\ (forall Y1 : Universe, (program_ Y1 -> (forall Z1 : Universe, decides_ X1 Y1 Z1)))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
