(*
% File     : COM003+2 : ILTP v1.1.2
% Domain   : Computing Theory
% Problem  : The halting problem is undecidable
% Version  : [Bru91] axioms.
% English  : 
% Refs     : [Gan98] Ganzinger (1998), Email to Geoff Sutcliffe
%          : [Bur87b] Burkholder (1987), A 76th Automated Theorem Proving Pr
%          : [Bru91] Brushi (1991), The Halting Problem
% Source   : [Bru91]
% Names    : - [Bru91]
% Status   : Theorem
% Rating   : 0.22 v3.1.0, 0.00 v2.5.0, 0.33 v2.4.0, 0.33 v2.2.1
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.75 v1.0.0
% Syntax   : Number of formulae    :   16 (   1 unit)
%            Number of atoms       :   52 (   0 equality)
%            Maximal formula depth :    8 (   6 average)
%            Number of connectives :   39 (   3 ~  ;   0  |;  15  &)
%                                         (  11 <=>;  10 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   17 (   0 propositional; 1-4 arity)
%            Number of functors    :    2 (   2 constant; 0-0 arity)
%            Number of variables   :   44 (   0 singleton;  37 !;   7 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : 
% Bugfixes : v2.2.0 - Clauses program_halts2_halts3_outputs_def, program_
%            not_halts2_halts3_outputs_def, program_halts2_halts2_outputs_
%            def, program_not_halts2_halts2_outputs_def, p4 by [Gan98].
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable program_program_decides_ : Universe -> Prop.
Variable program_not_halts2_halts3_outputs_ : Universe -> Universe -> Universe -> Universe -> Prop.
Variable program_not_halts2_halts2_outputs_ : Universe -> Universe -> Universe -> Prop.
Variable program_not_halts2_ : Universe -> Universe -> Prop.
Variable program_halts2_halts3_outputs_ : Universe -> Universe -> Universe -> Universe -> Prop.
Variable program_halts2_halts2_outputs_ : Universe -> Universe -> Universe -> Prop.
Variable program_halts2_ : Universe -> Universe -> Prop.
Variable program_decides_ : Universe -> Prop.
Variable program_ : Universe -> Prop.
Variable outputs_ : Universe -> Universe -> Prop.
Variable halts3_outputs_ : Universe -> Universe -> Universe -> Universe -> Prop.
Variable halts3_ : Universe -> Universe -> Universe -> Prop.
Variable halts2_outputs_ : Universe -> Universe -> Universe -> Prop.
Variable halts2_ : Universe -> Universe -> Prop.
Variable decides_ : Universe -> Universe -> Universe -> Prop.
Variable algorithm_program_decides_ : Universe -> Prop.
Variable algorithm_ : Universe -> Prop.

Variable good_ : Universe.
Variable bad_ : Universe.

Variable program_decides_def_1 : (forall X : Universe, (program_decides_ X <-> (forall Y : Universe, (program_ Y -> (forall Z : Universe, decides_ X Y Z))))).
Variable program_program_decides_def_2 : (forall X : Universe, (program_program_decides_ X <-> (program_ X /\ program_decides_ X))).
Variable algorithm_program_decides_def_3 : (forall X : Universe, (algorithm_program_decides_ X <-> (algorithm_ X /\ program_decides_ X))).
Variable program_halts2_def_4 : (forall X Y : Universe, (program_halts2_ X Y <-> (program_ X /\ halts2_ X Y))).
Variable halts3_outputs_def_5 : (forall X Y Z W : Universe, (halts3_outputs_ X Y Z W <-> (halts3_ X Y Z /\ outputs_ X W))).
Variable program_not_halts2_def_6 : (forall X Y : Universe, (program_not_halts2_ X Y <-> (program_ X /\ ~(halts2_ X Y)))).
Variable halts2_outputs_def_7 : (forall X Y W : Universe, (halts2_outputs_ X Y W <-> (halts2_ X Y /\ outputs_ X W))).
Variable program_halts2_halts3_outputs_def_8 : (forall X Y Z W : Universe, (program_halts2_halts3_outputs_ X Y Z W <-> (program_halts2_ Y Z -> halts3_outputs_ X Y Z W))).
Variable program_not_halts2_halts3_outputs_def_9 : (forall X Y Z W : Universe, (program_not_halts2_halts3_outputs_ X Y Z W <-> (program_not_halts2_ Y Z -> halts3_outputs_ X Y Z W))).
Variable program_halts2_halts2_outputs_def_10 : (forall X Y W : Universe, (program_halts2_halts2_outputs_ X Y W <-> (program_halts2_ Y Y -> halts2_outputs_ X Y W))).
Variable program_not_halts2_halts2_outputs_def_11 : (forall X Y W : Universe, (program_not_halts2_halts2_outputs_ X Y W <-> (program_not_halts2_ Y Y -> halts2_outputs_ X Y W))).
Variable p1_12 : ((exists X : Universe, algorithm_program_decides_ X) -> (exists W : Universe, program_program_decides_ W)).
Variable p2_13 : (forall W : Universe, (program_program_decides_ W -> (forall Y Z : Universe, (program_halts2_halts3_outputs_ W Y Z good_ /\ program_not_halts2_halts3_outputs_ W Y Z bad_)))).
Variable p3_14 : ((exists W : Universe, (program_ W /\ (forall Y : Universe, (program_halts2_halts3_outputs_ W Y Y good_ /\ program_not_halts2_halts3_outputs_ W Y Y bad_)))) -> (exists V : Universe, (program_ V /\ (forall Y : Universe, (program_halts2_halts2_outputs_ V Y good_ /\ program_not_halts2_halts2_outputs_ V Y bad_))))).
Variable p4_15 : ((exists V : Universe, (program_ V /\ (forall Y : Universe, (program_halts2_halts2_outputs_ V Y good_ /\ program_not_halts2_halts2_outputs_ V Y bad_)))) -> (exists U : Universe, (program_ U /\ (forall Y : Universe, ((program_halts2_ Y Y -> ~(halts2_ U Y)) /\ program_not_halts2_halts2_outputs_ U Y good_))))).

Theorem prove_this_16 : ~((exists X : Universe, algorithm_program_decides_ X)).
Proof.
  time hprover.
Qed.

End FOFProblem.
