(*
% File     : COM003+1 : ILTP v1.1.2
% Domain   : Computing Theory
% Problem  : The halting problem is undecidable
% Version  : [Bur87b] axioms.
% English  : 
% Refs     : [Bur87a] Burkholder (1987), The Halting Problem
%          : [Bur87b] Burkholder (1987), A 76th Automated Theorem Proving Pr
% Source   : [Bur87b]
% Names    : - [Bur87b]
% Status   : Theorem
% Rating   : 0.33 v3.1.0, 0.50 v2.7.0, 0.33 v2.6.0, 0.00 v2.5.0, 0.33 v2.4.0, 0.33 v2.2.1, 0.50 v2.2.0, 0.00 v2.1.0
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.75 v1.0.0
% Syntax   : Number of formulae    :    5 (   0 unit)
%            Number of atoms       :   55 (   0 equality)
%            Maximal formula depth :    9 (   8 average)
%            Number of connectives :   57 (   7 ~  ;   0  |;  32  &)
%                                         (   0 <=>;  18 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    6 (   0 propositional; 1-3 arity)
%            Number of functors    :    2 (   2 constant; 0-0 arity)
%            Number of variables   :   22 (   0 singleton;  15 !;   7 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable program_ : Universe -> Prop.
Variable outputs_ : Universe -> Universe -> Prop.
Variable halts3_ : Universe -> Universe -> Universe -> Prop.
Variable halts2_ : Universe -> Universe -> Prop.
Variable decides_ : Universe -> Universe -> Universe -> Prop.
Variable algorithm_ : Universe -> Prop.

Variable good_ : Universe.
Variable bad_ : Universe.

Variable p1_1 : ((exists X : Universe, (algorithm_ X /\ (forall Y : Universe, (program_ Y -> (forall Z : Universe, decides_ X Y Z))))) -> (exists W : Universe, (program_ W /\ (forall Y : Universe, (program_ Y -> (forall Z : Universe, decides_ W Y Z)))))).
Variable p2_2 : (forall W : Universe, ((program_ W /\ (forall Y : Universe, (program_ Y -> (forall Z : Universe, decides_ W Y Z)))) -> (forall Y Z : Universe, (((program_ Y /\ halts2_ Y Z) -> (halts3_ W Y Z /\ outputs_ W good_)) /\ ((program_ Y /\ ~(halts2_ Y Z)) -> (halts3_ W Y Z /\ outputs_ W bad_)))))).
Variable p3_3 : ((exists W : Universe, (program_ W /\ (forall Y : Universe, (((program_ Y /\ halts2_ Y Y) -> (halts3_ W Y Y /\ outputs_ W good_)) /\ ((program_ Y /\ ~(halts2_ Y Y)) -> (halts3_ W Y Y /\ outputs_ W bad_)))))) -> (exists V : Universe, (program_ V /\ (forall Y : Universe, (((program_ Y /\ halts2_ Y Y) -> (halts2_ V Y /\ outputs_ V good_)) /\ ((program_ Y /\ ~(halts2_ Y Y)) -> (halts2_ V Y /\ outputs_ V bad_))))))).
Variable p4_4 : ((exists V : Universe, (program_ V /\ (forall Y : Universe, (((program_ Y /\ halts2_ Y Y) -> (halts2_ V Y /\ outputs_ V good_)) /\ ((program_ Y /\ ~(halts2_ Y Y)) -> (halts2_ V Y /\ outputs_ V bad_)))))) -> (exists U : Universe, (program_ U /\ (forall Y : Universe, (((program_ Y /\ halts2_ Y Y) -> ~(halts2_ U Y)) /\ ((program_ Y /\ ~(halts2_ Y Y)) -> (halts2_ U Y /\ outputs_ U bad_))))))).

Theorem prove_this_5 : ~((exists X1 : Universe, (algorithm_ X1 /\ (forall Y1 : Universe, (program_ Y1 -> (forall Z1 : Universe, decides_ X1 Y1 Z1)))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
