(*
% File     : ALG211+1 : ILTP v1.1.2
% Domain   : General Algebra
% Problem  : Vector spaces and bases
% Version  : [Shu96] axioms : Especial.
% English  : 
% Refs     : [BG80]  Bishop & Goldberg (1980), Tensor Analysis on Manifolds
%          : [Sch96] Shults (1996), Email to Geoff Sutcliffe
% Source   : [Sch96]
% Names    : 
% Status   : Theorem
% Rating   : 0.00 v3.1.0
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.75 v1.1.0
% Syntax   : Number of formulae    :    6 (   0 unit)
%            Number of atoms       :   19 (   0 equality)
%            Maximal formula depth :    7 (   6 average)
%            Number of connectives :   13 (   0 ~  ;   0  |;   6  &)
%                                         (   1 <=>;   6 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    5 (   0 propositional; 1-2 arity)
%            Number of functors    :    3 (   1 constant; 0-2 arity)
%            Number of variables   :   17 (   0 singleton;  13 !;   4 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable lin_ind_subset_ : Universe -> Universe -> Prop.
Variable basis_of_ : Universe -> Universe -> Prop.
Variable a_vector_subspace_of_ : Universe -> Universe -> Prop.
Variable a_vector_space_ : Universe -> Prop.
Variable a_subset_of_ : Universe -> Universe -> Prop.

Variable vec_to_class_ : Universe -> Universe.
Variable union_ : Universe -> Universe -> Universe.

Variable basis_of_1 : (forall B V : Universe, (basis_of_ B V -> (lin_ind_subset_ B V /\ a_subset_of_ B (vec_to_class_ V)))).
Variable bg_2_2_5_2 : (forall S T V : Universe, ((lin_ind_subset_ S V /\ basis_of_ T V) -> (exists U : Universe, (a_subset_of_ U T /\ basis_of_ (union_ S U) V)))).
Variable bg_remark_63_a_3 : (forall A : Universe, (a_vector_space_ A -> (exists B : Universe, basis_of_ B A))).
Variable bg_2_4_a_4 : (forall A B : Universe, (a_vector_subspace_of_ A B -> a_vector_space_ A)).
Variable bg_2_4_2_5 : (forall W V E : Universe, ((a_vector_subspace_of_ W V /\ a_subset_of_ E (vec_to_class_ W)) -> (lin_ind_subset_ E W <-> lin_ind_subset_ E V))).

Theorem bg_2_4_3_6 : (forall W V : Universe, ((a_vector_subspace_of_ W V /\ a_vector_space_ V) -> (exists E F : Universe, (basis_of_ (union_ E F) V /\ basis_of_ E W)))).
Proof.
  time hprover.
Qed.

End FOFProblem.
