(*
% File     : ALG030+1 : ILTP v1.1.2
% Domain   : General Algebra
% Problem  : Groups 6: CPROPS-SORTED-DISCRIMINANT-PROBLEM-2
% Version  : Especial.
% English  : 
% Refs     : [Mei03] Meier (2003), Email to G.Sutcliffe
%          : [CM+04] Colton et al. (2004), Automatic Generation of Classifi
% Source   : [Mei03]
% Names    : 
% Status   : Theorem
% Rating   : 0.18 v3.1.0, 0.11 v2.7.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :    5 (   0 unit)
%            Number of atoms       :   26 (   6 equality)
%            Maximal formula depth :    9 (   6 average)
%            Number of connectives :   25 (   4 ~  ;   0  |;   4  &)
%                                         (   0 <=>;  17 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    3 (   0 propositional; 1-2 arity)
%            Number of functors    :    4 (   0 constant; 1-2 arity)
%            Number of variables   :   16 (   0 singleton;  16 !;   0 ?)
%            Maximal term depth    :    3 (   2 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable sorti2_ : Universe -> Prop.
Variable sorti1_ : Universe -> Prop.

Variable op2_ : Universe -> Universe -> Universe.
Variable op1_ : Universe -> Universe -> Universe.
Variable j_ : Universe -> Universe.
Variable h_ : Universe -> Universe.

Variable ax1_1 : (forall U : Universe, (sorti1_ U -> (forall V : Universe, (sorti1_ V -> sorti1_ (op1_ U V))))).
Variable ax2_2 : (forall U : Universe, (sorti2_ U -> (forall V : Universe, (sorti2_ V -> sorti2_ (op2_ U V))))).
Variable ax3_3 : ~((forall U : Universe, (sorti1_ U -> (forall V : Universe, (sorti1_ V -> (op1_ U V) = (op1_ V U)))))).
Variable ax4_4 : ~(~((forall U : Universe, (sorti2_ U -> (forall V : Universe, (sorti2_ V -> (op2_ U V) = (op2_ V U))))))).

Theorem co1_5 : (((forall U : Universe, (sorti1_ U -> sorti2_ (h_ U))) /\ (forall V : Universe, (sorti2_ V -> sorti1_ (j_ V)))) -> ~(((forall W : Universe, (sorti1_ W -> (forall X : Universe, (sorti1_ X -> (h_ (op1_ W X)) = (op2_ (h_ W) (h_ X)))))) /\ ((forall Y : Universe, (sorti2_ Y -> (forall Z : Universe, (sorti2_ Z -> (j_ (op2_ Y Z)) = (op1_ (j_ Y) (j_ Z)))))) /\ ((forall X1 : Universe, (sorti2_ X1 -> (h_ (j_ X1)) = X1)) /\ (forall X2 : Universe, (sorti1_ X2 -> (j_ (h_ X2)) = X2))))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
