(*
% File     : SYN918+1 : ILTP v1.1.2
% Domain   : Syntactic
% Problem  : From Smullyan
% Version  : Especial.
% English  : 
% Refs     : [Smu68] Smullyan (1968), First-Order Logic
%            [Shu04] Shults (2004), Email to G. Sutcliffe
% Source   : [Shu04]
% Names    :
% Status   : Theorem
% Rating   : 0.11 v3.1.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :    1 (   0 unit)
%            Number of atoms       :   15 (   0 equality)
%            Maximal formula depth :    8 (   8 average)
%            Number of connectives :   16 (   2 ~  ;   1  |;   6  &)
%                                         (   0 <=>;   7 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    3 (   0 propositional; 1-1 arity)
%            Number of functors    :    0 (   0 constant; --- arity)
%            Number of variables   :    6 (   0 singleton;   4 !;   2 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable h_ : Universe -> Prop.
Variable g_ : Universe -> Prop.
Variable f_ : Universe -> Prop.



Set Firstorder Depth 10.

Theorem prove_this_1 : (((forall X : Universe, (((f_ X /\ g_ X) -> h_ X) -> (exists Y : Universe, (f_ Y /\ ~(g_ Y))))) /\ ((forall W : Universe, (f_ W -> g_ W)) \/ (forall Z : Universe, (f_ Z -> h_ Z)))) -> ((forall R : Universe, ((f_ R /\ h_ R) -> g_ R)) -> (exists V : Universe, (f_ V /\ (g_ V /\ ~(h_ V)))))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
