(*
% File     : SYN548+1 : ILTP v1.1.2
% Domain   : Syntactic (Translated)
% Problem  : dia box (box (p or box q)<=>box p or box q)
% Version  : Especial.
% English  : 
% Refs     : [Wei94] Weidenbach (1994), Email to G. Sutcliffe
%          : [Che80] Chellas (1980), Modal Logic
% Source   : [Wei94]
% Names    : 
% Status   : Theorem
% Rating   : 0.89 v3.1.0, 0.50 v2.7.0, 0.67 v2.6.0, 0.33 v2.5.0, 0.67 v2.4.0, 0.33 v2.2.1
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :    3 (   1 unit)
%            Number of atoms       :   14 (   0 equality)
%            Maximal formula depth :   11 (   6 average)
%            Number of connectives :   11 (   0 ~  ;   2  |;   2  &)
%                                         (   1 <=>;   6 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    3 (   0 propositional; 1-2 arity)
%            Number of functors    :    1 (   1 constant; 0-0 arity)
%            Number of variables   :   10 (   0 singleton;   9 !;   1 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : These are modal logic problems translated to FOF. The problems 
%            can be easily solved by theorem proving methods for modal logic, 
%            but their (naive) translation into first-order logic results in 
%            hard first-order problems. The first-order translation of the 
%            box, diamond operators is:
%                [box P]x  :=  (all y R(x,y) -> [P]y)
%                [dia P]x  :=  (exists R(x,y) & [P]y)
%                [P]x  :=  P(x)  if P is an atom
%            where we start with some initial context 'o' (the initial world),
%            i.e. we translate a formula P into [P]o. [Wei94]
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable reachable_ : Universe -> Universe -> Prop.
Variable q_ : Universe -> Prop.
Variable p_ : Universe -> Prop.

Variable initial_world_ : Universe.

Variable reflexivity_of_reachable_1 : (forall X : Universe, reachable_ X X).
Variable transitivity_of_reachable_2 : (forall X Y Z : Universe, ((reachable_ X Y /\ reachable_ Y Z) -> reachable_ X Z)).

Set Firstorder Depth 10.

Theorem prove_this_3 : (exists X : Universe, (reachable_ initial_world_ X /\ (forall Y : Universe, (reachable_ X Y -> ((forall Z : Universe, (reachable_ Y Z -> (p_ Z \/ (forall V : Universe, (reachable_ Z V -> q_ V))))) <-> ((forall W : Universe, (reachable_ Y W -> p_ W)) \/ (forall W : Universe, (reachable_ Y W -> q_ W)))))))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
