(*
% File     : SYN405+1 : ILTP v1.1.2
% Domain   : Syntactic
% Problem  : Kalish and Montague Problem 239
% Version  : Especial.
% English  : Laws of alphabetic variance.
% Refs     : [KM64]  Kalish & Montegue (1964), Logic: Techniques of Formal 
%          : [Hah94] Haehnle (1994), Email to G. Sutcliffe
% Source   : [Hah94]
% Names    : kalish239 [Hah94]
% Status   : Theorem
% Rating   : 0.00 v2.1.0
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.00 v1.0.0
% Syntax   : Number of formulae    :    1 (   0 unit)
%            Number of atoms       :    4 (   0 equality)
%            Maximal formula depth :    4 (   4 average)
%            Number of connectives :    3 (   0 ~  ;   0  |;   2  &)
%                                         (   0 <=>;   1 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    2 (   0 propositional; 1-1 arity)
%            Number of functors    :    0 (   0 constant; --- arity)
%            Number of variables   :    3 (   0 singleton;   1 !;   2 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable g_ : Universe -> Prop.
Variable f_ : Universe -> Prop.



Set Firstorder Depth 10.

Theorem kalish239_1 : (((forall X : Universe, f_ X) /\ (exists Y : Universe, g_ Y)) -> (exists Z : Universe, (f_ Z /\ g_ Z))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
