(*
% File     : SYN364+1 : ILTP v1.1.2
% Domain   : Syntactic
% Problem  : Peter Andrews Problem X2115
% Version  : Especial.
% English  : 
% Refs     : [And86] Andrews (1986), An Introduction to Mathematical Logic 
%          : [And94] Andrews (1994), Email to G. Sutcliffe
% Source   : [And94]
% Names    : X2115 [And86]
% Status   : Theorem
% Rating   : 0.00 v2.1.0
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.25 v1.0.0
% Syntax   : Number of formulae    :    1 (   0 unit)
%            Number of atoms       :    9 (   0 equality)
%            Maximal formula depth :    8 (   8 average)
%            Number of connectives :    9 (   1 ~  ;   1  |;   4  &)
%                                         (   0 <=>;   3 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    3 (   0 propositional; 1-2 arity)
%            Number of functors    :    2 (   0 constant; 1-2 arity)
%            Number of variables   :    8 (   0 singleton;   5 !;   3 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable big_q_ : Universe -> Prop.
Variable big_p_ : Universe -> Universe -> Prop.
Variable big_m_ : Universe -> Prop.

Variable g_ : Universe -> Universe.
Variable f_ : Universe -> Universe -> Universe.


Set Firstorder Depth 10.

Theorem x2115_1 : (((forall X : Universe, ((exists Y : Universe, big_p_ X Y) -> (forall Z : Universe, big_p_ Z Z))) /\ ((forall U : Universe, (exists V : Universe, (big_p_ U V \/ (big_m_ U /\ big_q_ (f_ U V))))) /\ (forall W : Universe, (big_q_ W -> ~(big_m_ (g_ W)))))) -> (forall U : Universe, (exists V : Universe, (big_p_ (g_ U) V /\ big_p_ U U)))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
