(*
% File     : SYN082+1 : ILTP v1.1.2
% Domain   : Syntactic
% Problem  : Pelletier Problem 60
% Version  : Especial.
% English  : 
% Refs     : [Pel86] Pelletier (1986), Seventy-five Problems for Testing Au
%          : [Pel88] Pelletier (1988), Errata
%          : [Hah94] Haehnle (1994), Email to G. Sutcliffe
% Source   : [Hah94]
% Names    : Pelletier 60 [Pel86]
% Status   : Theorem
% Rating   : 0.00 v2.1.0
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.00 v1.0.0
% Syntax   : Number of formulae    :    1 (   0 unit)
%            Number of atoms       :    4 (   0 equality)
%            Maximal formula depth :    7 (   7 average)
%            Number of connectives :    3 (   0 ~  ;   0  |;   1  &)
%                                         (   1 <=>;   1 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    1 (   0 propositional; 2-2 arity)
%            Number of functors    :    1 (   0 constant; 1-1 arity)
%            Number of variables   :    3 (   0 singleton;   2 !;   1 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : This problem is incorrect in [Pel86] and is corrected in [Pel88].
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable big_f_ : Universe -> Universe -> Prop.

Variable f_ : Universe -> Universe.


Set Firstorder Depth 10.

Theorem pel60_1 : (forall X : Universe, (big_f_ X (f_ X) <-> (exists Y : Universe, ((forall Z : Universe, (big_f_ Z Y -> big_f_ Z (f_ X))) /\ big_f_ X Y)))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
