(*
% File     : SYN079+1 : ILTP v1.1.2
% Domain   : Syntactic
% Problem  : Pelletier Problem 57
% Version  : Especial.
% English  : 
% Refs     : [Pel86] Pelletier (1986), Seventy-five Problems for Testing Au
%          : [Hah94] Haehnle (1994), Email to G. Sutcliffe
% Source   : [Hah94]
% Names    : Pelletier 57 [Pel86]
% Status   : Theorem
% Rating   : 0.00 v2.1.0
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.00 v1.0.0
% Syntax   : Number of formulae    :    4 (   3 unit)
%            Number of atoms       :    6 (   0 equality)
%            Maximal formula depth :    6 (   2 average)
%            Number of connectives :    2 (   0 ~  ;   0  |;   1  &)
%                                         (   0 <=>;   1 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    1 (   0 propositional; 2-2 arity)
%            Number of functors    :    4 (   3 constant; 0-2 arity)
%            Number of variables   :    3 (   0 singleton;   3 !;   0 ?)
%            Maximal term depth    :    2 (   2 average)
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable big_f_ : Universe -> Universe -> Prop.

Variable f_ : Universe -> Universe -> Universe.
Variable c_ : Universe.
Variable b_ : Universe.
Variable a_ : Universe.

Variable pel57_1_1 : big_f_ (f_ a_ b_) (f_ b_ c_).
Variable pel57_2_2 : big_f_ (f_ b_ c_) (f_ a_ c_).
Variable pel57_3_3 : (forall X Y Z : Universe, ((big_f_ X Y /\ big_f_ Y Z) -> big_f_ X Z)).

Set Firstorder Depth 10.

Theorem pel57_4 : big_f_ (f_ a_ b_) (f_ a_ c_).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
