(*
% File     : SYN076+1 : ILTP v1.1.2
% Domain   : Syntactic
% Problem  : Pelletier Problem 53
% Version  : Especial.
% English  : 
% Refs     : [Pel86] Pelletier (1986), Seventy-five Problems for Testing Au
%          : [Hah94] Haehnle (1994), Email to G. Sutcliffe
% Source   : [Hah94]
% Names    : Pelletier 53 [Pel86]
% Status   : Theorem
% Rating   : 0.78 v3.1.0, 0.83 v2.7.0, 0.67 v2.5.0, 0.33 v2.4.0, 0.33 v2.2.1, 0.50 v2.1.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :    2 (   0 unit)
%            Number of atoms       :    9 (   7 equality)
%            Maximal formula depth :    8 (   7 average)
%            Number of connectives :    8 (   1 ~  ;   1  |;   1  &)
%                                         (   5 <=>;   0 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    2 (   0 propositional; 2-2 arity)
%            Number of functors    :    0 (   0 constant; --- arity)
%            Number of variables   :   11 (   0 singleton;   5 !;   6 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable big_f_ : Universe -> Universe -> Prop.
Variable EqCongruence_big_f : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> big_f_ x1 x2 -> big_f_ y1 y2 .


Variable pel53_1_1 : (exists X Y : Universe, (X <> Y /\ (forall Z : Universe, (Z = X \/ Z = Y)))).

Set Firstorder Depth 10.

Theorem pel53_2 : ((exists Z : Universe, (forall X : Universe, ((exists W : Universe, (forall Y : Universe, (big_f_ X Y <-> Y = W))) <-> X = Z))) <-> (exists W1 : Universe, (forall Y1 : Universe, ((exists Z1 : Universe, (forall X1 : Universe, (big_f_ X1 Y1 <-> X1 = Z1))) <-> Y1 = W1)))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
