(*
% File     : SYN072+1 : ILTP v1.1.2
% Domain   : Syntactic
% Problem  : Pelletier Problem 49
% Version  : Especial.
% English  : 
% Refs     : [Pel86] Pelletier (1986), Seventy-five Problems for Testing Au
%          : [Hah94] Haehnle (1994), Email to G. Sutcliffe
% Source   : [Hah94]
% Names    : Pelletier 49 [Pel86]
% Status   : Theorem
% Rating   : 0.11 v3.1.0, 0.17 v2.7.0, 0.00 v2.4.0, 0.00 v2.3.0, 0.33 v2.2.1, 0.00 v2.1.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :    5 (   4 unit)
%            Number of atoms       :    6 (   3 equality)
%            Maximal formula depth :    5 (   2 average)
%            Number of connectives :    2 (   1 ~  ;   1  |;   0  &)
%                                         (   0 <=>;   0 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    2 (   0 propositional; 1-2 arity)
%            Number of functors    :    2 (   2 constant; 0-0 arity)
%            Number of variables   :    4 (   0 singleton;   2 !;   2 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable big_p_ : Universe -> Prop.
Variable EqCongruence_big_p : forall x1 y1 : Universe, x1 = y1 -> big_p_ x1 -> big_p_ y1 .

Variable b_ : Universe.
Variable a_ : Universe.

Variable pel49_1_1 : (exists X Y : Universe, (forall Z : Universe, (Z = X \/ Z = Y))).
Variable pel49_2_2 : big_p_ a_.
Variable pel49_3_3 : big_p_ b_.
Variable pel49_4_4 : a_ <> b_.

Set Firstorder Depth 10.

Theorem pel49_5 : (forall X : Universe, big_p_ X).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
