(*
% File     : SYN069+1 : ILTP v1.1.2
% Domain   : Syntactic
% Problem  : Pelletier Problem 45
% Version  : Especial.
% English  : 
% Refs     : [KM64]  Kalish & Montegue (1964), Logic: Techniques of Formal 
%          : [Pel86] Pelletier (1986), Seventy-five Problems for Testing Au
%          : [Hah94] Haehnle (1994), Email to G. Sutcliffe
% Source   : [Hah94]
% Names    : Pelletier 45 [Pel86]
% Status   : Theorem
% Rating   : 0.11 v3.1.0, 0.00 v2.5.0, 0.33 v2.4.0, 0.33 v2.2.1, 0.00 v2.1.0
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.00 v1.0.0
% Syntax   : Number of formulae    :    4 (   0 unit)
%            Number of atoms       :   18 (   0 equality)
%            Maximal formula depth :    7 (   6 average)
%            Number of connectives :   16 (   2 ~  ;   0  |;  10  &)
%                                         (   0 <=>;   4 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    6 (   0 propositional; 1-2 arity)
%            Number of functors    :    0 (   0 constant; --- arity)
%            Number of variables   :    9 (   0 singleton;   5 !;   4 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable big_l_ : Universe -> Prop.
Variable big_k_ : Universe -> Prop.
Variable big_j_ : Universe -> Universe -> Prop.
Variable big_h_ : Universe -> Universe -> Prop.
Variable big_g_ : Universe -> Prop.
Variable big_f_ : Universe -> Prop.


Variable pel45_1_1 : (forall X : Universe, ((big_f_ X /\ (forall Y : Universe, ((big_g_ Y /\ big_h_ X Y) -> big_j_ X Y))) -> (forall Y1 : Universe, (big_g_ Y1 /\ (big_h_ X Y1 /\ big_k_ Y1))))).
Variable pel45_2_2 : ~((exists Y : Universe, (big_l_ Y /\ big_k_ Y))).
Variable pel45_3_3 : (exists X : Universe, (big_f_ X /\ ((forall Y : Universe, (big_h_ X Y -> big_l_ Y)) /\ (forall Y1 : Universe, ((big_g_ Y1 /\ big_h_ X Y1) -> big_j_ X Y1))))).

Set Firstorder Depth 10.

Theorem pel45_4 : (exists X : Universe, (big_f_ X /\ ~((exists Y : Universe, (big_g_ Y /\ big_h_ X Y))))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
