(*
% File     : SYN063+1 : ILTP v1.1.2
% Domain   : Syntactic
% Problem  : Pelletier Problem 33
% Version  : Especial.
% English  : 
% Refs     : [KM64]  Kalish & Montegue (1964), Logic: Techniques of Formal 
%          : [Pel86] Pelletier (1986), Seventy-five Problems for Testing Au
%          : [Hah94] Haehnle (1994), Email to G. Sutcliffe
% Source   : [Hah94]
% Names    : Pelletier 33 [Pel86]
% Status   : Theorem
% Rating   : 0.11 v3.1.0, 0.00 v2.5.0, 0.33 v2.4.0, 0.33 v2.2.1, 0.00 v2.1.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :    1 (   0 unit)
%            Number of atoms       :   10 (   0 equality)
%            Maximal formula depth :    7 (   7 average)
%            Number of connectives :   12 (   3 ~  ;   4  |;   2  &)
%                                         (   1 <=>;   2 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    1 (   0 propositional; 1-1 arity)
%            Number of functors    :    3 (   3 constant; 0-0 arity)
%            Number of variables   :    2 (   0 singleton;   2 !;   0 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : This is a monadic predicate formulation of Pelletier 17.
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable big_p_ : Universe -> Prop.

Variable c_ : Universe.
Variable b_ : Universe.
Variable a_ : Universe.


Set Firstorder Depth 10.

Theorem pel33_1 : ((forall X : Universe, ((big_p_ a_ /\ (big_p_ X -> big_p_ b_)) -> big_p_ c_)) <-> (forall X1 : Universe, ((~(big_p_ a_) \/ (big_p_ X1 \/ big_p_ c_)) /\ (~(big_p_ a_) \/ (~(big_p_ b_) \/ big_p_ c_))))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
