(*
% File     : SYN062+1 : ILTP v1.1.2
% Domain   : Syntactic
% Problem  : Pelletier Problem 32
% Version  : Especial.
% English  : 
% Refs     : [KM64]  Kalish & Montegue (1964), Logic: Techniques of Formal 
%          : [Pel86] Pelletier (1986), Seventy-five Problems for Testing Au
%          : [Hah94] Haehnle (1994), Email to G. Sutcliffe
% Source   : [Hah94]
% Names    : Pelletier 32 [Pel86]
% Status   : Theorem
% Rating   : 0.00 v2.1.0
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.00 v1.0.0
% Syntax   : Number of formulae    :    4 (   0 unit)
%            Number of atoms       :   12 (   0 equality)
%            Maximal formula depth :    5 (   4 average)
%            Number of connectives :    8 (   0 ~  ;   1  |;   3  &)
%                                         (   0 <=>;   4 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    6 (   0 propositional; 1-1 arity)
%            Number of functors    :    0 (   0 constant; --- arity)
%            Number of variables   :    4 (   0 singleton;   4 !;   0 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable big_k_ : Universe -> Prop.
Variable big_j_ : Universe -> Prop.
Variable big_i_ : Universe -> Prop.
Variable big_h_ : Universe -> Prop.
Variable big_g_ : Universe -> Prop.
Variable big_f_ : Universe -> Prop.


Variable pel32_1_1 : (forall X : Universe, ((big_f_ X /\ (big_g_ X \/ big_h_ X)) -> big_i_ X)).
Variable pel32_2_2 : (forall X : Universe, ((big_i_ X /\ big_h_ X) -> big_j_ X)).
Variable pel32_3_3 : (forall X : Universe, (big_k_ X -> big_h_ X)).

Set Firstorder Depth 10.

Theorem pel32_4 : (forall X : Universe, ((big_f_ X /\ big_k_ X) -> big_j_ X)).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
