(*
% File     : SYN060+1 : ILTP v1.1.2
% Domain   : Syntactic
% Problem  : Pelletier Problem 30
% Version  : Especial.
% English  : 
% Refs     : [KM64]  Kalish & Montegue (1964), Logic: Techniques of Formal 
%          : [Pel86] Pelletier (1986), Seventy-five Problems for Testing Au
%          : [Hah94] Haehnle (1994), Email to G. Sutcliffe
% Source   : [Hah94]
% Names    : Pelletier 30 [Pel86]
% Status   : Theorem
% Rating   : 0.11 v3.1.0, 0.00 v2.5.0, 0.33 v2.4.0, 0.33 v2.2.1, 0.00 v2.1.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :    3 (   1 unit)
%            Number of atoms       :    8 (   0 equality)
%            Maximal formula depth :    5 (   4 average)
%            Number of connectives :    7 (   2 ~  ;   1  |;   1  &)
%                                         (   0 <=>;   3 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    4 (   0 propositional; 1-1 arity)
%            Number of functors    :    0 (   0 constant; --- arity)
%            Number of variables   :    3 (   0 singleton;   3 !;   0 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable big_i_ : Universe -> Prop.
Variable big_h_ : Universe -> Prop.
Variable big_g_ : Universe -> Prop.
Variable big_f_ : Universe -> Prop.


Variable pel30_1_1 : (forall X : Universe, ((big_f_ X \/ big_g_ X) -> ~(big_h_ X))).
Variable pel30_2_2 : (forall X : Universe, ((big_g_ X -> ~(big_i_ X)) -> (big_f_ X /\ big_h_ X))).

Set Firstorder Depth 10.

Theorem pel30_3 : (forall X : Universe, big_i_ X).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
