(*
% File     : SYN059+1 : ILTP v1.1.2
% Domain   : Syntactic
% Problem  : Pelletier Problem 29
% Version  : Especial.
% English  : 
% Refs     : [KM64]  Kalish & Montegue (1964), Logic: Techniques of Formal 
%          : [Pel86] Pelletier (1986), Seventy-five Problems for Testing Au
%          : [Hah94] Haehnle (1994), Email to G. Sutcliffe
% Source   : [Hah94]
% Names    : Pelletier 29 [Pel86]
% Status   : Theorem
% Rating   : 0.00 v2.1.0
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.25 v1.0.0
% Syntax   : Number of formulae    :    3 (   2 unit)
%            Number of atoms       :   10 (   0 equality)
%            Maximal formula depth :    6 (   3 average)
%            Number of connectives :    7 (   0 ~  ;   0  |;   3  &)
%                                         (   1 <=>;   3 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    4 (   0 propositional; 1-1 arity)
%            Number of functors    :    0 (   0 constant; --- arity)
%            Number of variables   :    6 (   0 singleton;   4 !;   2 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable big_j_ : Universe -> Prop.
Variable big_h_ : Universe -> Prop.
Variable big_g_ : Universe -> Prop.
Variable big_f_ : Universe -> Prop.


Variable pel29_1_1 : (exists X : Universe, big_f_ X).
Variable pel29_2_2 : (exists Y : Universe, big_g_ Y).

Set Firstorder Depth 10.

Theorem pel29_3 : (((forall X : Universe, (big_f_ X -> big_h_ X)) /\ (forall U : Universe, (big_g_ U -> big_j_ U))) <-> (forall W Y : Universe, ((big_f_ W /\ big_g_ Y) -> (big_h_ W /\ big_j_ Y)))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
