(*
% File     : SYN058+1 : ILTP v1.1.2
% Domain   : Syntactic
% Problem  : Pelletier Problem 28
% Version  : Especial.
% English  : 
% Refs     : [KM64]  Kalish & Montegue (1964), Logic: Techniques of Formal 
%          : [Pel86] Pelletier (1986), Seventy-five Problems for Testing Au
%          : [Pel88] Pelletier (1988), Errata
%          : [Hah94] Haehnle (1994), Email to G. Sutcliffe
% Source   : [Hah94]
% Names    : Pelletier 28 [Pel86]
% Status   : Theorem
% Rating   : 0.11 v3.1.0, 0.00 v2.5.0, 0.33 v2.4.0, 0.33 v2.2.1, 0.00 v2.1.0
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.00 v1.0.0
% Syntax   : Number of formulae    :    4 (   0 unit)
%            Number of atoms       :   12 (   0 equality)
%            Maximal formula depth :    4 (   4 average)
%            Number of connectives :    8 (   0 ~  ;   1  |;   2  &)
%                                         (   0 <=>;   5 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    6 (   0 propositional; 1-1 arity)
%            Number of functors    :    0 (   0 constant; --- arity)
%            Number of variables   :    7 (   0 singleton;   5 !;   2 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : This problem is incorrect in [Pel86] and is corrected in [Pel88].
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable big_s_ : Universe -> Prop.
Variable big_r_ : Universe -> Prop.
Variable big_q_ : Universe -> Prop.
Variable big_p_ : Universe -> Prop.
Variable big_g_ : Universe -> Prop.
Variable big_f_ : Universe -> Prop.


Variable pel28_1_1 : (forall X : Universe, (big_p_ X -> (forall Z : Universe, big_q_ Z))).
Variable pel28_2_2 : ((forall X : Universe, (big_q_ X \/ big_r_ X)) -> (exists X1 : Universe, (big_q_ X1 /\ big_s_ X1))).
Variable pel28_3_3 : ((exists X : Universe, big_s_ X) -> (forall X1 : Universe, (big_f_ X1 -> big_g_ X1))).

Set Firstorder Depth 10.

Theorem pel28_4 : (forall X : Universe, ((big_p_ X /\ big_f_ X) -> big_g_ X)).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
